(function() {
const __create = Scene_Title.prototype.create;
Scene_Title.prototype.create = function() {
    __create.apply(this, arguments);
    const w = Graphics.width >> 1, h = Graphics.height >> 1;

    this.blackOut = new Bitmap(w, h);
    this.blackOut.fillRect(0,0,w,h,"black");
    this._fadeSprite = new Sprite(this.blackOut);
    this._fadeSprite.scale.x = this._fadeSprite.scale.y = 2;
    this.fadeInCnt  = 30;
    this.fadeOutCnt = 0;
    this.inScene = true;
    this.addChild(this._fadeSprite);
};

Scene_Title.prototype.start = function() {
    Scene_Base.prototype.start.call(this);
    SceneManager.clearStack();
    this.playTitleMusic();
    this._commandWindow.open();
};

Scene_Title.prototype.isBusy = function() {
    return this.inScene;
};

Scene_Title.prototype.createBackground = function() {
    this._backSprite1 = new Sprite(ImageManager.loadTitle1($dataSystem.title1Name+langType));
    this._backSprite1.bitmap.smooth = false;
    this._backSprite1.scale.x = this._backSprite1.scale.y = 2;
    this.addChild(this._backSprite1);
    this._versionInfo = new Sprite(ImageManager.loadTitle1($dataSystem.title1Name));
    this._versionInfo.bitmap.smooth = false;
    this._versionInfo.x = 48  <<1;
    this._versionInfo.y = 176 <<1;
    this._versionInfo.scale.x = this._versionInfo.scale.y = 2;
    this.addChild(this._versionInfo);
};

Scene_Title.prototype.update = function() {
    Scene_Base.prototype.update.call(this);
    if (this.fadeInCnt != 0){
        switch (this.fadeInCnt--){
            case 25:
                this._fadeSprite.bitmap = ImageManager.loadPicture("fade1");
                break;
            case 20:
                this._fadeSprite.bitmap = ImageManager.loadPicture("fade2");
                break;
            case 15:
                this._fadeSprite.bitmap = ImageManager.loadPicture("fade3");
                break;
            case 10:
                this._fadeSprite.bitmap = ImageManager.loadPicture("fade4");
                break;
            case 5:
                this._fadeSprite.bitmap = null;
        };
    }else if (this.fadeOutCnt != 0){
        switch (this.fadeOutCnt--){
            case 25:
                this._fadeSprite.bitmap = ImageManager.loadPicture("fade4");
                break;
            case 20:
                this._fadeSprite.bitmap = ImageManager.loadPicture("fade3");
                break;
            case 15:
                this._fadeSprite.bitmap = ImageManager.loadPicture("fade2");
                break;
            case 10:
                this._fadeSprite.bitmap = ImageManager.loadPicture("fade1");
                break;
            case 5:
                this._fadeSprite.bitmap = this.blackOut;
                this.inScene = false;
                break;
        };
    }
};

Scene_Title.prototype.createForeground = function() {};

Scene_Title.prototype.commandNewGame = function() {
    DataManager.setupNewGame();
    this.fadeOutCnt = 30;
    AudioManager.fadeOutBgm(this.slowFadeSpeed() / 60);
    SceneManager.goto(Scene_Map);
};

Scene_Title.prototype.commandContinue = function() {
    this.fadeOutCnt = 30;
    SceneManager.push(Scene_Load);
};

Scene_Title.prototype.commandOptions = function() {
    this.fadeOutCnt = 30;
    SceneManager.push(Scene_Options);
};

    var _Window_TitleCommand_updatePlacement =
            Window_TitleCommand.prototype.updatePlacement;
    Window_TitleCommand.prototype.updatePlacement = function() {
        _Window_TitleCommand_updatePlacement.call(this);
        this.x = 45;
        this.y -= 4;
        this.opacity = 0;
    };

    Window_TitleCommand.prototype.lineHeight = function() { return 48; };
    Window_TitleCommand.prototype.windowWidth = function() { return 180; };
    Window_TitleCommand.prototype.drawItem = function() {};

    Window_TitleCommand.prototype._refreshCursor = function() {
        var pad = this._padding;
        var x = Math.max(this._cursorRect.x + pad - this.origin.x, pad);
        var y = Math.max(this._cursorRect.y + pad - this.origin.y, pad);
        this._windowCursorSprite.bitmap = ImageManager.loadTitle1("cursor");
        this._windowCursorSprite.move(x, y+14);
    };

    Window_TitleCommand.prototype._updateCursor = function() {
        this._windowCursorSprite.alpha = 255;
        this._windowCursorSprite.visible = true;
    };
})();
