function Window_Gold2() { this.initialize.apply(this, arguments);}
Window_Gold2.prototype = Object.create(Window_Gold.prototype);
Window_Gold2.prototype.constructor = Window_Gold2;

Window_Gold2.prototype.windowWidth = function() {
    return 192;
};

(function(){
    // Window_MenuCommand
	Window_MenuCommand.prototype.standardFontSize = function() {
		return romanLanguage() ? 10 : 20;
	};

    Window_MenuCommand.prototype.windowWidth = function() {
        return Window_Gold2.prototype.windowWidth.call(this);
    };

    Window_MenuCommand.prototype.addOptionsCommand = function() {
    };

    // Window_MenuStatus
    Window_MenuStatus.prototype.drawItemImage = function(index) {
        const actor = $gameParty.members()[index];
        const rect = this.itemRect(index);
        this.changePaintOpacity(actor.isBattleMember());
        this.drawActorFace(actor, rect.x+4, rect.y+3);
        this.drawActorIcons(actor, rect.x+4, rect.y, 96);
        this.changePaintOpacity(true);
    };

    Window_MenuStatus.prototype.drawItemStatus = function(index) {
        const actor = $gameParty.members()[index];
        var rect = this.itemRect(index);
        var x = rect.x + 96;
        var y = rect.y + rect.height / 2 - this.lineHeight() * 1.5;
        var width = rect.width - x - this.textPadding()-4;
        this.drawActorSimpleStatus(actor, x+24, y, width);
    };

    // Window_GameEnd
	Window_GameEnd.prototype.standardFontSize = function() {
		return romanLanguage() ? 10 : 20;
	};

    const __makeCammandList = Window_GameEnd.prototype.makeCommandList;
    Window_GameEnd.prototype.makeCommandList = function() {
        this.addCommand(TextManager.options, 'config');
        __makeCammandList.call(this);
    };

    // Scene_GameEnd
    const __createCommandWindow = Scene_GameEnd.prototype.createCommandWindow;
    Scene_GameEnd.prototype.createCommandWindow = function() {
        __createCommandWindow.call(this);
        this._commandWindow.setHandler('config',  this.commandOptions.bind(this));
    };

    Scene_GameEnd.prototype.commandOptions = function() {
        SceneManager.push(Scene_Options);
    };

    // Scene_Menu
    const __create = Scene_Menu.prototype.create;
    Scene_Menu.prototype.create = function(){
        __create.apply(this, arguments);
        this._commandWindow.setHandler('status',    this.commandStatus.bind(this));
        this.createTimeWindow();
    }

    Scene_Menu.prototype.commandStatus = function() {
        SceneManager.push(Scene_Status);
    };

    Scene_Menu.prototype.createTimeWindow = function(){
        this._timeWindow = new Window_Base(
            this._commandWindow.x,
            this._commandWindow.y+this._commandWindow.height,
            this._commandWindow.width,
            Graphics.height - this._commandWindow.y - 
            this._commandWindow.height - this._goldWindow.height
        );
        this.addChild(this._timeWindow);
        this._timeCnt = 0;
        this.updateTimeWindow();
    }

    Scene_Menu.prototype.createGoldWindow = function() {
        this._goldWindow = new Window_Gold2(0, 0);
        this._goldWindow.y = Graphics.boxHeight - this._goldWindow.height;
        this.addWindow(this._goldWindow);
    };

    const __start = Scene_Menu.prototype.start;
    Scene_Menu.prototype.start = function() {
        this._statusWindow.width = Graphics.width-this._goldWindow.width;
        this._statusWindow.createContents();
        __start.call(this);
    };

    const __update = Scene_Menu.prototype.update;
    Scene_Menu.prototype.update = function(){
        __update.apply(this, arguments);
        this.updateTimeWindow();
    }

    Scene_Menu.prototype.updateTimeWindow = function(){
        if (this._timeCnt == 0){
            this._timeCnt = 60;
            this._timeWindow.contents.clear();
            this._timeWindow.changeTextColor(this._timeWindow.systemColor());
            const wid = this._timeWindow.contents.width;
            this._timeWindow.drawText(TextManager._playtime,0,0,wid,'center');
            this._timeWindow.changeTextColor(this._timeWindow.normalColor());
            this._timeWindow.drawText($gameSystem.playtimeText(),0,32,wid,'center');
        }else{
            this._timeCnt--;
        }
    }
})();