(function(){
	Window_ItemList.prototype.maxCols = function(){ return 2; };
	Window_ItemList.prototype.spacing = function(){ return 0; };

	Window_ItemCategory.prototype.standardFontSize = function() {
		return romanLanguage() ? 10 : 20;
	};

	// Window_ShopCommand
	Window_ShopCommand.prototype.standardFontSize = function() {
		return romanLanguage() ? 10 : 20;
	};

	// Window_SkillList
	Window_SkillList.prototype.spacing = function(){ return 0; };

	// Window_SkillType
	Window_SkillType.prototype.update = function() {
		Window_Command.prototype.update.call(this);
	};
	
	Window_SkillType.prototype.setSkillWindow = function(skillWindow) {
		this._skillWindow = skillWindow;
		this._skillWindow.setStypeId(1);
	};
	
	Window_SkillType.prototype.standardFontSize = function() {
		return romanLanguage() ? 10 : 20;
	};

	Window_SkillType.prototype.numVisibleRows = function(){ return 3; };
	Window_SkillType.prototype.windowWidth = function(){ return 200; };

	Window_SkillType.prototype.makeCommandList = function() {
		if (this._actor) {
			this._actor.addedSkillTypes().forEach(function(stypeId) {
				var name = $dataSystem.skillTypes[stypeId];
				this.addCommand(name, 'skill', true, stypeId);
			}, this);
			this.addCommand(TextManager._previousActor,"pagedown")
			this.addCommand(TextManager._nextActor,"pagedown")
		}
	};

	// Window_MenuActor
	Window_MenuActor.prototype.windowWidth = function() {
		return 376;
	};

	// Window_SkillStatus
	Window_SkillStatus.prototype.refresh = function() {
		this.contents.clear();
		if (this._actor) {
			var w = this.width - this.padding * 2;
			var width = w - 86 - this.textPadding();
			this.drawActorFace(this._actor, 0, 0);
			this.drawActorSimpleStatus(this._actor, 104, 0, width);
		}
	};

	// Scene_Skill
	Scene_Skill.prototype.createStatusWindow = function() {
		var wx = this._skillTypeWindow.width;
		var wy = this._helpWindow.height;
		var ww = Graphics.boxWidth - wx;
		var wh = this._skillTypeWindow.height;
		this._statusWindow = new Window_SkillStatus(wx, wy, ww, wh);
		this._statusWindow.reserveFaceImages();
		this.addWindow(this._statusWindow);
	};


	// Scene_Status
	Scene_Status.prototype.create = function() {
		Scene_MenuBase.prototype.create.call(this);
		this._statusWindow = new Window_Status();
		this._statusWindow.setHandler('cancel',   this.popScene.bind(this));
		this._statusWindow.reserveFaceImages();
		this.addWindow(this._statusWindow);
	};
	
	Scene_Status.prototype.start = function() {
		Scene_MenuBase.prototype.start.call(this);
		this._statusWindow.refresh();
	};

	// Window_Status
	Window_Status.prototype.initialize = function() {
		const width  = Graphics.boxWidth;
		const hpad   = 12;
		const height = Graphics.boxHeight+(hpad<<1);
		Window_Selectable.prototype.initialize.call(this, 0, -hpad, width, height);
		this._actor = null;
		this.refresh();
		this.activate();
	};

	Window_Status.prototype.itemHeight = function() {
		return 111;
	};

	Window_Status.prototype.refresh = function() {
		this.contents.clear();
		let idx = 0, lineHeight = 16;
		let x = 0;
		$gameParty.members().forEach(function(actor){
			const rect = this.itemRect(idx++);
			rect.x += 8;
			rect.y += 1;
			this.drawActorFace(actor, rect.x, rect.y)
			this.drawActorSimpleStatus(actor, rect.x + 100, rect.y, 258);

			x = rect.x + 360;
			for (var i = 0; i < 6; i++) {
				var paramId = i + 2;
				var y2 = rect.y + lineHeight * i-4;
				this.changeTextColor(this.systemColor());
				this.drawText(TextManager.param(paramId), x, y2, 160);
				this.resetTextColor();
				this.drawText(actor.param(paramId), x + 80, y2, 90, 'right');
			}
		}, this);
	};

	
})();