(function(){
    Game_Actor.prototype.equipSlots = function() {
        var slots = [1,2,3,3,3];
        if (this.isDualWield()) { slots[1] = 1; }
        return slots;
    };


    // Window_EquipCommand
    Window_EquipCommand.prototype.maxCols = function() {
        return 1;
    };
    Window_EquipCommand.prototype.lineHeight = function() {
        return 28;
    };
    const __itemRect = Window_EquipCommand.prototype.itemRectForText;
    Window_EquipCommand.prototype.itemRectForText = function(idx) {
        const rect = __itemRect.call(this,idx);
        rect.y+=4
        return rect;
    };

    // Window_EquipSlot
    Window_EquipSlot.prototype.itemHeight = function(){
        return 36;
    }
    Window_EquipSlot.prototype.lineHeight = function(){
        return 32;
    }
    Window_EquipSlot.prototype.drawItem = function(index) {
        if (this._actor) {
            var rect = this.itemRectForText(index);
            this.changeTextColor(this.systemColor());
            this.changePaintOpacity(this.isEnabled(index));
            this.drawText(this.slotName(index), rect.x, rect.y+16, rect.width,"right");
            this.drawItemName(this._actor.equips()[index], rect.x, rect.y);
            this.changePaintOpacity(true);
        }
    };


    // Window_EquipStatus
    Window_EquipStatus.prototype.windowWidth = function() {
        return 218;
    };
    Window_EquipStatus.prototype.lineHeight = function() {
        return 16;
    };
    Window_EquipStatus.prototype.windowHeight = function() {
        return this.fittingHeight(this.numVisibleRows())+30;
    };
    Window_EquipStatus.prototype.refresh = function() {
        this.contents.clear();
        if (this._actor) {
            if (romanLanguage()){
                this.contents.fontSize = 16;
            }else{
                this.contents.fontSize = 10;
            }
            this.drawActorName(this._actor, this.textPadding(), 10);
            this.contents.fontSize = 10;
            let y = 20;
            for (var i = 0; i < 6; i++) {
                y += 18;
                this.drawItem(0, y, i+2);
            }
        }
    };
    Window_EquipStatus.prototype.drawItem = function(x, y, paramId) {
        this.drawParamName(x + this.textPadding(), y, paramId);
        if (this._actor) {
            this.drawCurrentParam(x + 80, y, paramId);
        }
        this.drawRightArrow(x + 120, y);
        if (this._tempActor) {
            this.drawNewParam(x + 144, y, paramId);
        }
    };

    // Scene_Equip
    Scene_Equip.prototype.createCommandWindow = function() {
        var wx = 0;
        var wy = this._helpWindow.y + this._helpWindow.height;
        var ww = this._statusWindow.width;
        this._commandWindow = new Window_EquipCommand(wx, wy, ww);
        this._commandWindow.setHelpWindow(this._helpWindow);
        this._commandWindow.setHandler('equip',    this.commandEquip.bind(this));
        this._commandWindow.setHandler('optimize', this.commandOptimize.bind(this));
        this._commandWindow.setHandler('clear',    this.commandClear.bind(this));
        this._commandWindow.setHandler('cancel',   this.popScene.bind(this));
        this._commandWindow.setHandler('pagedown', this.nextActor.bind(this));
        this._commandWindow.setHandler('pageup',   this.previousActor.bind(this));
        this.addWindow(this._commandWindow);
        this._statusWindow.y = this._commandWindow.y + this._commandWindow.height;
    };


    Scene_Equip.prototype.createSlotWindow = function() {
        var wx = this._statusWindow.width;
        var wy = this._commandWindow.y;
        var ww = Graphics.boxWidth - this._statusWindow.width;
        var wh = this._statusWindow.height+ + this._commandWindow.height;
        this._slotWindow = new Window_EquipSlot(wx, wy, ww, wh);
        this._slotWindow.setHelpWindow(this._helpWindow);
        this._slotWindow.setStatusWindow(this._statusWindow);
        this._slotWindow.setHandler('ok',       this.onSlotOk.bind(this));
        this._slotWindow.setHandler('cancel',   this.onSlotCancel.bind(this));
        this.addWindow(this._slotWindow);
    };
})();