function Scene_Grosse(){ this.initialize.apply(this, arguments); }
Scene_Grosse.prototype = Object.create(Scene_MonsterMutter.prototype);
Scene_Grosse.prototype.constructor = Scene_Grosse;

function Window_DgsList(){ this.initialize.apply(this, arguments); }
Window_DgsList.prototype = Object.create(Window_MenuStatus.prototype);
Window_DgsList.prototype.constructor = Window_DgsList;

/*
0  HP
1  MP
2  ATK
3  DEF
4  MGC
5  MDF
6  SPD
*/

(function(){
    function obtainItems (actor) {
        let list = [];
        if (actor){
            for (let i = 30; i <= 66; i++){
                const item = $dataItems[i];
                if (actor.actorId() == item.meta.crt) {
                    list = list.concat(item.meta.dmt);
                    break;
                };
            }
        }
        let exp = actor.currentExp() >> 1;
        const paramItems = {};
        let dActor = actor.actor();
        if (exp >= 200 && !!dActor.meta.dmt){
            paramItems[Number(dActor.meta.dmt)] = 1;
        };
        let n = 0;
        n = Math.floor(exp / 10000);
        exp -= n * 10000;
        if (n > 0){ list.push([22, n]); };
        n = Math.floor(exp / 1000);
        exp -= n * 1000;
        if (n > 0){ list.push([21, n]); };
        n = Math.floor(exp / 100);
        if (n > 0){ list.push([20, n]); };

        dActor = [100,25];
        for (let i = 0; i < 7; i++){
            if (!paramItems[i]) { paramItems[i] = 0; };
            paramItems[i] += Math.floor(actor._paramPlus[i] / (dActor[i] || 10));
            if (paramItems[i] != 0) {list.push([73+i, paramItems[i]]); };
        };
        return list;
    };

    Game_Interpreter.prototype.__obtainItems = function(actor){
        return obtainItems(actor);
    }

    Window_DgsList.prototype.actor = function() {
        return $gameParty.members()[this.index()];
    };

    Window_DgsList.prototype.isCurrentItemEnabled = function() {
        return this.isEnabled(this.index());
    };

    Window_DgsList.prototype.isEnabled = function(index){
        const actor = $gameParty.members()[index];
        return actor && actor.actorId() !== 1;
    };

    Window_DgsList.prototype.drawItem = function(index) {
        this.changePaintOpacity(this.isEnabled(index));
        Window_MenuStatus.prototype.drawItem.call(this, index);
        this.changePaintOpacity(1);
    };

    Window_DgsList.prototype.drawItemBackground = function(index) {};
    Window_DgsList.prototype.drawItemImage = function(index) {
        const actor = $gameParty.members()[index];
        if (actor){
            const rect = this.itemRect(index);
            this.drawActorFace(actor, rect.x+1, rect.y+1);
        }
    };

    Window_DgsList.prototype.select = function(idx){
        Window_ItemList.prototype.select.call(this, idx);
        this._statusWindow && this.refreshStatusWindow();
    }

    Window_DgsList.prototype.setStatusWindow = function(window) {
        this._statusWindow = window;
        this.activate();
        this.select(0);
    };

    Window_DgsList.prototype.drawItemStatus = function(index) {
        const actor = $gameParty.members()[index];
        var rect = this.itemRect(index);
        var x = rect.x + 73;
        var y = rect.y + rect.height / 2 - this.lineHeight() * 1.5;
        var width = rect.width - x - this.textPadding();
        this.drawActorSimpleStatus(actor, x+24, y, width);
    };
    
    Window_DgsList.prototype.refreshStatusWindow = function() {
        const actor = this.actor();
        function refresh (actor){
            this.contents.clear();
            this.changeTextColor(this.systemColor());
            const w = this.contents.width;
            this.drawText(TextManager.dieGrosse,0,0,w,"center");
            if (actor){
                let y = 16;
                this.changeTextColor(this.systemColor());
                this.drawText(TextManager.exp,0,y,w);
                this.changeTextColor(this.normalColor());
                this.drawText(actor.currentExp(),0,y,w,"right");
                for (let i = 2; i < 8; i++){
                    y+=16;
                    this.changeTextColor(this.systemColor());
                    this.drawText(TextManager.param(i),0,y,w);
                    this.changeTextColor(this.normalColor());
                    this.drawText(actor.param(i),0,y,w,"right");
                }
                y += 36;
                this.changeTextColor(this.systemColor());
                this.drawText(TextManager.drObtainable,0,y-20,w);
                obtainItems(actor).forEach(function(list){
                    const item = $dataItems[list[0]];
                    this.drawItemName(item,0,y,w);
                    this.drawText(
                        $gameParty.numItems(item) + "+" + ("  "+list[1]).slice(-2),
                        0,y+16,w,"right"
                    );
                    y += 32;
                }, this);
            }
        };
        refresh.call(this._statusWindow, actor);
    };

    // Scene_Grosse
    Scene_Grosse.prototype.create = function() {
        Scene_MenuBase.prototype.create.call(this);
        this.createItemWindow();
        this.createStatusWindow();
    };

    Scene_Grosse.prototype.start = function() {
        Scene_MonsterMutter.prototype.start.call(this);
        this._itemWindow.refresh();
    }

    Scene_Grosse.prototype.createItemWindow = function() {
        this._itemWindow = new Window_DgsList(0,0);
        this._itemWindow.setHandler('ok',     this.onItemOk.bind(this));
        this._itemWindow.setHandler('cancel', this.popScene.bind(this));
        this._itemWindow.reserveFaceImages();
        this.addWindow(this._itemWindow);
    };

    Scene_Grosse.prototype.createStatusWindow = function(){
        this._statusWindow = new Window_Base(
            this._itemWindow.width, this._itemWindow.y,
            Graphics.width - this._itemWindow.width, this._itemWindow.height
        );
        this._itemWindow.setStatusWindow(this._statusWindow);
        this.addWindow(this._statusWindow);
    }

    Scene_Grosse.prototype.onItemOk = function(){
        const actor = this._itemWindow.actor();
        if (actor){
            $gameVariables.setValue(2, actor);
            $gameVariables.setValue(3, actor.name());
            $gameVariables.setValue(4, obtainItems(actor));
            this.popScene();
        }else{
            this._itemWindow.activate();
        }
    }
})();