let langType = "EN";

function Scene_Language(){this.initialize.apply(this, arguments);};
Scene_Language.prototype = Object.create(Scene_Base.prototype);
Scene_Language.prototype.constructor = Scene_Language;

function Window_LanguageList(){this.initialize.apply(this, arguments);};
Window_LanguageList.prototype = Object.create(Window_Command.prototype);
Window_LanguageList.prototype.constructor = Window_LanguageList;

// Scene_Language
Scene_Language.prototype.create = function(){
	Scene_Base.prototype.create.apply(this, arguments);
	this._waitCnt = 60;
	this.createWindowLayer();
	this.createCommandWindow();
	this.createDescSprite();
};

Scene_Language.prototype.isBusy = function() {
    return this._waitCnt != 0;
};

Scene_Language.prototype.createCommandWindow = function(){
	this._commandWindow = new Window_LanguageList();
	this.addWindow(this._commandWindow);
};

Scene_Language.prototype.createDescSprite = function(){
	const wh = 96;
	this._descSprite = new Sprite(new Bitmap(Graphics.width, wh));
	this._descSprite.x = 8;
	this._descSprite.y = Graphics.height-wh;
	this.addChild(this._descSprite);
}

Scene_Language.prototype.update = function(){
	Scene_Base.prototype.update.apply(this, arguments);
	if(!this._descSprite.visible && this._waitCnt){ this._waitCnt--; };
	this.updateDescText();
};

Scene_Language.prototype.updateDescText = function(){
	const idx = this._commandWindow.index();
	if (idx !== this._lastIndex){
		this._descSprite.bitmap.clear();
		this._descSprite.bitmap.drawText(
			this._commandWindow.isCommandEnabled(idx),0,0,255,24);
		this._lastIndex = idx;
	}
}

Scene_Language.prototype.onListOk = function(symbol){
	this["translateInto"+symbol]();
	langType = symbol;
	this._commandWindow.visible = false;
	this._descSprite.visible = false;

const r1 = /<dmt:(\d+)x(\d+)>/;
const re = /<dmt:(\d+)x(\d+)>/g;
function setDmt(item){
	item.meta.dmt = [];
	const match = item.note.match(re);
	if (!match) { return false; };
	match.forEach(function(dmt){
		r1.test(dmt) && item.meta.dmt.push([Math.floor(RegExp.$1), Math.floor(RegExp.$2)]);
	});
	return item.meta.dmt.length > 0;
};
$dataWeapons.concat($dataArmors).forEach(function(item){ item && setDmt(item);});
$dataItems.forEach(function(item){
	let cnt = 0;
	if (item && setDmt(item)) {
		if (item.description.length > 0) { return };
		item.description = "\\c[1]"+TextManager._itemIngredients+"\\c[0]";
		item.meta.dmt.forEach(function(dmt){
			item.description += $dataItems[dmt[0]].name+":"+dmt[1]+" ";
			if (cnt == 0){ item.description += "\n"; };
			cnt++;
		});
	};
});
	SceneManager.goto(Scene_Title);
}



// Window_LanguageList
Window_LanguageList.prototype.initialize = function(){
	Window_Command.prototype.initialize.call(this,0,0);
	this.x = (Graphics.width  - this.windowWidth()) >>1;
	this.y = (Graphics.height - this.windowHeight())>>1;
	this.activate();
	this.refresh();
	this.openness = 0;
	this.open();
}

Window_LanguageList.prototype.itemTextAlign = function(){return "center";}
Window_LanguageList.prototype.standardFontSize = function(){return 24;}

Window_LanguageList.prototype.callOkHandler = function() {
	const scene = SceneManager._scene;
	scene.onListOk.call(scene, this.currentSymbol());
};

;(function(){
const __setChoices = Game_Message.prototype.setChoices;
Game_Message.prototype.setChoices = function(choices, defaultType, cancelType) {
	choices = choices.map(function(term){
		return $dataSystem._choices[term.toUpperCase()] || term;
	});
	__setChoices.call(this, choices, defaultType, cancelType);
};

Game_Message.prototype.allText = function(){
	const text = key = this._texts.join('\n');
	return text.replace(/\\t\[(\d+)\]/g, function(_,n){ return $dataSystem._messageList[n]; });
};

})();