(function(){
    Weather.prototype._createBitmaps = function() {
        this._rainBitmap = new Bitmap(16, 48);
        let x = 16;
        const w = 2, h = 16;
        for (let y = 0; y < 48; y+=h){
            this._rainBitmap.fillRect(x -= w,y,w,h,'white');
        };
        this._stormBitmap = new Bitmap(1, 1);
        this._snowBitmap  = new Bitmap(1, 1);
    };

    Weather.prototype._updateRainSprite = function(sprite) {
        sprite.bitmap = this._rainBitmap;
        const rate = 0.196; //Math.PI / 16
        sprite.ax -= 6 * Math.sin(rate);
        sprite.ay += 6 * Math.cos(rate);
        sprite.opacity -= 6;
    };
    
    
})();