(function() {
    Game_Party.prototype.leader = function() {
        return $gameActors.actor(1);
    };

    Window_Base.prototype.drawFace = function(faceName, faceIndex, x, y, width, height) {
        if (!faceName) { return };
        var bitmap = ImageManager.loadFace(faceName);
        const _WH = 32;
        width = width || _WH;
        height = height || _WH;
        var pw = _WH;
        var ph = _WH;
        var sw = Math.min(width, pw);
        var sh = Math.min(height, ph);
        var dx = Math.floor(x + Math.max(width - pw, 0) / 2);
        var dy = Math.floor(y + Math.max(height - ph, 0) / 2);
        var sx = faceIndex % 4 * pw + (pw - sw) / 2;
        var sy = Math.floor(faceIndex / 4) * ph + (ph - sh) / 2;

        this.contents._context.save();
        this.contents._context.imageSmoothingEnabled=false;
        this.contents._context.msImageSmoothingEnabled=false; 
        this.contents.blt(bitmap, sx, sy, sw, sh, dx, dy, sw*3,sh*3)
        this.contents._context.restore();
    };

    Window_Message.prototype.newLineX = function() {
        return $gameMessage.faceName() === '' ? 0 : 110;
    };

    const __updatePosition = Sprite_Character.prototype.updatePosition;
    Sprite_Character.prototype.updatePosition = function() {
        __updatePosition.apply(this, arguments);
        this.bitmap.smooth = false;
        this.scale.x = this.scale.y = 2;
    };

    Window_NameEdit.prototype.drawChar = function(index) {
        const rect = this.itemRect(index);
        this.resetTextColor();
        this.drawText(this._name[index]||'', rect.x, rect.y,rect.width,"center");
    };

    Window_NameEdit.prototype.left = function(){ return 128; };
    Window_NameEdit.prototype.charWidth = function(){ return 32; };
	Window_NameInput.prototype.standardFontSize = function(){ return 24; };

    Window_NameEdit.prototype.windowHeight = function() { return this.fittingHeight(3); };
    Window_NameEdit.prototype.itemRect = function(index) {
        return {
            x: this.left() + index * this.charWidth(),
            y: 32,
            width: this.charWidth(),
            height: this.lineHeight()
        };
    };

	Window_NameEdit.prototype.standardFontSize = function() {
		return 24;
	};

    Window_NameInput.JAPAN1 = [
        "あ","か","さ","た","な","は","ま","や","ら","ん",
        "い","き","し","ち","に","ひ","み","ゆ","り","カナ",
        "う","く","す","つ","ぬ","ふ","む","よ","る","変換",
        "え","け","せ","て","ね","へ","め","わ","れ","DEL",
        "お","こ","そ","と","の","ほ","も","を",'ろ',"OK",
    ]
    Window_NameInput.JAPAN2 = [
        "ア","カ","サ","タ","ナ","ハ","マ","ヤ","ラ","ン",
        "イ","キ","シ","チ","ニ","ヒ","ミ","ユ","リ","ABC",
        "ウ","ク","ス","ツ","ヌ","フ","ム","ヨ","ル","変換",
        "エ","ケ","セ","テ","ネ","ヘ","メ","ワ","レ","DEL",
        "オ","コ","ソ","ト","ノ","ホ","モ","ヲ",'ロ',"OK",
    ]
    Window_NameInput.LATIN1 = [
        "0","1","2","3","4","5","6","7","8","9",
        "A","B","C","D","E","F","G","+","-","abc",
        "H","I","J","K","L","M","N","*",":","CAP",
        "O","P","Q","R","S","T","U",",",".","DEL",
        "V","W","X","Y","Z","!","?","'",' ',"OK",
    ]
    Window_NameInput.LATIN2 = [
        "0","1","2","3","4","5","6","7","8","9",
        "a","b","c","d","e","f","g","+","-","ひら",
        "h","i","j","k","l","m","n","*",":","CAP",
        "o","p","q","r","s","t","u",",",".","DEL",
        "v","w","x","y","z","!","?","'",' ',"OK",
    ]
    Window_NameInput.prototype.maxCols = function() { return 10; };
    Window_NameInput.prototype.maxItems = function() { return 50; };
    Window_NameInput.prototype.windowHeight = function() { return this.fittingHeight(5); };
    Window_NameInput.prototype.table = function() {
        if (langType=="JP"){
            return [
                Window_NameInput.JAPAN1, Window_NameInput.JAPAN2,
                Window_NameInput.LATIN1, Window_NameInput.LATIN2,
            ];
        }else{
            return [
                Window_NameInput.LATIN1, Window_NameInput.LATIN2,
                Window_NameInput.JAPAN1, Window_NameInput.JAPAN2,
            ];
        }
    };
    Window_NameInput.prototype.character = function() {
        return [19,29,39,49].contains(this._index) ? '' : this.table()[this._page][this._index]; };

    Window_NameInput.prototype.isPageChange = function() { return this._index === 19; };
    Window_NameInput.prototype.isCapsChange = function() { return this._index === 29; };
    Window_NameInput.prototype.isDel        = function() { return this._index === 39; };
    Window_NameInput.prototype.isOk         = function() { return this._index === 49; };

    Window_NameInput.prototype.itemRect = function(index) {
        const w = index != 9 && index % 10 == 9 ? 10 : 0;
        return {
            x: index % 10 * 42+w,
            y: Math.floor(index / 10) * this.lineHeight(),
            width: 42+w,
            height: this.lineHeight()
        };
    };
    
    Window_NameInput.prototype.updateCursor = function() {
        var rect = this.itemRect(this._index);
        this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
    };
    
    Window_NameInput.prototype.cursorDown = function(wrap) {
        if (this._index < 40 || wrap) { this._index = (this._index + 10) % 50; }
    };
    Window_NameInput.prototype.cursorUp = function(wrap) {
        if (this._index >= 10 || wrap) { this._index = (this._index + 40) % 50; }
    };

    Window_NameInput.prototype.processJump = function() {
        if (this._index !== 49) {
            this._index = 49;
            SoundManager.playCursor();
        }
    };

Window_NameInput._convJPN=
"ぅゔづっあぁいぃうぅえぇおぉかがきぎくぐけげこごさざしじすずせぜそぞただちぢつづてでとど"+
"ばぱびぴぶぷべぺぼぽはばひびふぶへべほぼやゃゆゅよょ"+
"ゥヴヅッアァイィウゥエェオォカガキギクグケゲコゴサザシジスズセゼソゾタダチヂツヅテデトド"+
"バパビピブプベペボポハバヒビフブヘベホボヤャユュヨョ"+
"\"''`";

    const __processOk = Window_NameInput.prototype.processOk;
    Window_NameInput.prototype.processOk = function() {
        if (this.isDel()) {
            this.processBack();
            return true;
        }else if(this.isCapsChange()){
            let name = this._editWindow._name;
            if (name.length > 0){
                let last=name.slice(-1);
                let idx;
                for (idx = 0; idx < Window_NameInput._convJPN.length; idx++){
                    if (last == Window_NameInput._convJPN[idx]){ break; };
                }
                if (idx == Window_NameInput._convJPN.length){
                    if      (/^[A-Z]/.test(last)){
                        last = last.toLowerCase();
                    }else if(/^[a-z]/.test(last)){
                        last = last.toUpperCase();
                    };
                }else{
                    last = Window_NameInput._convJPN[idx % 2 ? idx-1 : idx+1];
                }
                this._editWindow._name = name.slice(0,-1) + last;
                this._editWindow.refresh();
            }
            SoundManager.playOk();
            return true;
        }else{
            return __processOk.apply(this, arguments);
        }
    };

    const __create = Scene_Name.prototype.create;
    Scene_Name.prototype.create = function() {
        __create.apply(this, arguments);
        this._editWindow.y  = 20;
        this._inputWindow.y = this._editWindow.y + this._editWindow.height;
    };
})();
