**"The Evolution of Trust"**

This interactive guide is heavily based off Robert Axelrod's groundbreaking 1984 book, [The Evolution of Cooperation](https://www.amazon.com/Evolution-Cooperation-Revised-Robert-Axelrod/dp/0465005640)! I was also heavily inspired by his 1997 sequel, [The Complexity of Cooperation](http://press.princeton.edu/titles/6144.html), and Robert Putnam's 2000 book on America's declining "social capital", [Bowling Alone](http://bowlingalone.com/).

yes i'm a bookworm nerd, plz don't bully me

**"Fewer and fewer people say they trust each other"**

To see a thorough statistical take on this, check out [Our World In Data](https://ourworldindata.org/trust). Mmmm stats~

**"The Game of Trust"**

This game is also known in game theory as the infamous *Prisoner's Dilemma*. The Prisoner's Dilemma is named after a story where two suspects can either squeal on their partner-in-crime ("cheat"), or stay silent ("cooperate"). I chose not to do this story because 1) in this case, both players "cooperating" would be bad for society, and 2) it's unrealistic, everyone knows that snitches get stitches

**"You won't know in advance when the last round is"**

In the repeated game of trust (also known as *Iterated Prisoner's Dilemma*), it's important that neither player knows *when* the last round is. Why? Think about it - on the last round, both players would know their action has no consequence, so they'd both cheat. But that means in the second-last round, their actions can't change the next round, so they'd also both cheat. But that means in the third-last round... etc etc.

**"Copycat"**

This strategy is better known in game theory as *Tit For Tat*. It was created by Anatol Rapoport in 1980, for Robert Axelrod's game theory tournament. I chose not to use the name "Tit For Tat" because 1) it *sounds* mean, although it's a nice & fair strategy, and 2) a lot of the public have already heard about Tit For Tat, so if I used that name, players might just place their bets on this character because they've already heard of "Tit For Tat".

**"You may be skeptical about the Christmas Truce"**

There was another guy who was skeptical, too. During the truce, a German corporal remarked with disgust, ["Such a thing should not happen in wartime. Have you no German sense of honor?"](http://time.com/3643889/christmas-truce-1914/)

That man was Adolf Hitler.

You can't make this sh\*t up.

**"For culture to evolve"**

There's a new, super-young interdisciplinary field that I'm really *excited* by, called *Cultural Evolution*. Admittedly, it's a bad name, not least because it sounds uncomfortably close to "Social Darwinism". Which it's not. Pinky promise.

One core part of Cultural Evolution Theory is culture evolves the same way life does: through variation & selection. Variation: people differ in beliefs & behaviors, and invent new ones almost every day. Selection: people try to imitate their heroes & elders, and adopt their beliefs/behaviors.

(Note: this is *not* quite Richard Dawkin's "meme" theory. "Meme" implies, that, like genes, ideas come in discrete chunks & replicate with high fidelity. This is obviously untrue. Also you can't say "meme" with a straight face these days, so whatever)

The reason why I think Cultural Evolution is so promising, is that it could integrate *all* the human sciences: psychology, sociology, economics, anthropology, political science, neuroscience, biology. The greatest problems of our time do not obey conventional academic boundaries – so, it's about dang time we created a common language between the sciences and humanities.

If you want to learn more about Cultural Evolution Theory, I highly recommend Joseph Heinlich's 2015 book, [The Secret of Our Success](http://press.princeton.edu/titles/10543.html)!

**"[Always Cheat's] exploitativeness was its downfall"**

You may have heard that someone found a player strategy that can "exploit evolution". From the [Scientific American](https://www.scientificamerican.com/article/game-theory-calls-cooperation-into-question1/): "[Press & Dyson's results] suggested the best strategies were selfish ones that led to extortion, not cooperation."

Press & Dyson's findings *are* really important, but Scientific American confused two different uses of the word "evolutionary". The first use, the way this interactive guide used it, was to mean that the *tournament's population* changes over time. The second use, the way P&D meant it, was that the *player's rules* changes over time. For example: Detective is "evolutionary" since it changes its own rules, while Copycat is *not* "evolutionary" since it sticks to its principles.

So, P&D found strategies that could exploit "evolutionary" *players* like Detective, but their strategies _still could not exploit the evolution of the tournament_, because in the long run, fair & nice strategies still win. 

**"We have fewer friends -- period."**

Seriously, go read Robert Putnam's 2000 book, [Bowling Alone](http://bowlingalone.com/). Yeah it's a bit outdated by now, 17 years later, but its core findings and lessons are still true as ever -- probably even more so.

**"Non-zero-sum game" / "Win-Win"**

This is kinda cheesy, but I still adore the 1989 book, [The Seven Habits of Highly Effective People](https://www.amazon.com/Habits-Highly-Effective-People-Powerful/dp/0743269519) -- especially Habit #4: Think Win-Win.

Because, contrary to popular belief, coming up with Win-Win solutions is hard, takes lots of effort, and is emotionally painful. Heck, I'd go even further – I'd say our culture's default stance of Win-Lose "us versus them" is the easy path, the lazy path, the equivalent of activism junk food.

Anyway. Exaggerations aside, I strongly believe "Win-Win" / "Non-Zero-Sum" is something we all urgently need -- in our personal lives, social lives, and _definitely_ political lives.

**"Copykitten"**

Just like how Copycat's original name was Tit For Tat, Copykitten's original name is *Tit For Two Tats*. Same rule: Cooperate, unless the other players cheats *twice* in a row.

There's another forgiving variant of Tit For Tat called *Generous Tit For Tat*. It's got a similar but slightly different rule: Cooperate, but when the other player cheats, forgive them with a X% chance. This design, with the variable "X", lets you set different "forgiveness" levels for the player.

**"Simpleton"**

Also known as Pavlov, or Win-Shift-Lose-Stay.

**"Our modern media [...] has increased our miscommunication"**

I'm only in my twenties, I don't know why I always sound like an old grump shaking my fist at a cloud. But, yeah, anyway, go read Neil Postman's 1985 book, [Amusing Ourselves To Death](https://www.amazon.com/Amusing-Ourselves-Death-Discourse-Business/dp/014303653X). It's about how the communications technology we use subtly shapes our culture ("the medium is the message") and how technology that is biased towards quick & fast information (TV in 1985, social media now) turns us all into trivial, short-term thinkers.

Although I don't agree with _everything_ in his book, it's a real eye-opener, and surprisingly prescient for 1985. His rant against Sesame Street is kinda weird, though.

**"Build relationships. Find win-wins. Communicate clearly."**

Giving advice can come off as condescending, so let me be perfectly honest: I do *not* have any of this figured out, personally. I'm bad at developing friendships, especially with people of different political views than me. I occasionally forget about win-wins, and lapse into "us versus them" thinking. And judging by this rambling, I'm also still terrible at communicating clearly.

But I want to get better. This stuff is *hard*. Building peace & trust in the world, from the bottom up, is *hard*.

And that's why it's worth it. <3
