//========================================================================================
//=== TSR_FootSteps === A Plugin by The Northern Frog ====================================
//========================================================================================

var TSR = TSR || {};
TSR.footStep = TSR.footStep || {};
TSR.footStep.version = 1.42;

var Imported = Imported || {};
Imported.TSR_FootSteps = true;

//========================================================================================

/*:
 * @target MZ
 * @plugindesc v1.4.2 Add foot step prints to player, followers and events, when
 *        walking on map regions Id or terrain Tags defined by Map Notetags. 
 * 
 * @author TSR, The Northern Frog, 2020      
 * @help 
 * =======================================================================================
 * == About this Plugin ==================================================================
 * =======================================================================================
 * The Plugin use the sprite sheet 'FootSteps.png' that must be imported in 
 * the /img/system folder of your game. You can download it on my itch.io
 * account, along with the Plugin file.
 *
 * The sprite sheet is divided into 8 sections, hereafter named Blocks.
 * Blocks are indexed as bellow:
 *
 *      ---------------------------------------------------
 *      |           |           |            |            |
 *      |           |           |            |            |
 *      |    0      |     1     |      2     |     3      |
 *      |           |           |            |            |
 *      |           |           |            |            |
 *      |-----------|-----------|------------|------------|
 *      |           |           |            |            |
 *      |           |           |            |            |
 *      |    4      |     5     |      6     |     7      |
 *      |           |           |            |            |
 *      |           |           |            |            |
 *      ---------------------------------------------------
 *
 * Each Block consist of 12 frames of 48x48px. A Block can be either 
 * 'Regular' or 'Animated'. All Blocks are 'Regular', but can be turned 
 * into 'Animated' Blocks using parameters.
 *
 *   Regular Blocks
 *   ==============
 *   The 12 frames of a Regular Block are arranged in 4 lines corresponding
 *   to the 4 directions of the characters. Each time a character prints a 
 *   step, it alternate between the 3 frames on the line corresponding to 
 *   its direction.
 *
 *   Animated Blocks
 *   ===============
 *   The 12 frames of an Animated Block are read one after the others,
 *   according to parameters settings. You can create various step animation
 *   effect using the parameters (see bellow). The Plugin comes with default
 *   animations settings for Blocks 4 and 5 (Water) and Block 6 (Bush). 
 *
 * 
 *   Adding more Blocks
 *   ==================
 *   The sprite sheet contains 8 Blocks, but more can be added if needed.
 *   To do so, expand the sprite sheet height. Each row of 144 px height
 *   will add 4 additional Blocks to the sheet.
 *
 *
 *
 * NOTETAGS
 * =======================================================================================
 * The Plugin works with Map Notetags that assign Map Region Id or Terrain
 * Tags to specific Blocks. The first parameter of the plugin define if 
 * you're using region Ids or terrain Tags. Bellow, the term 'region id' 
 * is used for simplicity.
 *
 * Map Notetags
 * ============
 *
 *         <FOOT STEP REGIONS: x, y, z>     
 *            When walking on region id x, y or z, the characters will prints
 *            steps from the default Block. 
 *
 *
 *         <WET STEP REGIONS: x, y, z>    
 *            When walking on region id x, y or z, the characters will prints
 *            steps from the default Block.    
 *
 *     
 *         <animation name REGIONS: x, y, z>
 *             These are the Notetags to mark Map Region Id that will print
 *             animated foot steps according to the 'animation name' set in 
 *             the parameters (see bellow).  
 *   
 *             But to serves as an example and template, the Plugin comes
 *             with default settings for 'Water' and 'Bush' step animations.
 *             Hence, you can use the following Notetags as Plug & Play.
 *            
 *                    <WATER REGIONS: x, y, z>
 *
 *                    <BUSH REGIONS: x, y, z>       
 *
 * 
 *    Wet Feet
 *    =======
 *    The 'Foot Step' and 'Wet Step' Notetags are the same. But when leaving a
 *    region marked as 'Wet Step', the characters will keep printing steps on 
 *    the 3 first tiles outside of the 'wet' area. This may comes useful for 
 *    damp areas like Snow or Mud. 
 *
 *
 *    Default Block
 *    =============
 *    The Default Block is the Block that will be printed whenever the Player,
 *    a Follower or an Event, walk on a map region Id marked as 'Foot Step' or
 *    'Wet Step'. The Default Block is index 0, but it can be changed with the
 *    corresponding Parameter.
 *
 *    But if you want an Actor or an Event to print a specific Block, use the
 *    following Notetags:
 *
 *
 *
 * Actors Notetags or Events Comment Tags
 * ======================================
 *
 *        <FOOT STEP: x>
 *           A character with this Notetag will print steps from Block x when
 *           walking on a map region Id marked as 'Foot Step' or 'Wet Step'.
 *
 *        <animation name STEP: x>
 *           A character with this Notetag will print steps from Block x when
 *           walking on a map region Id marked as 'animation name'.
 * 
 *        The Plug & Play default settings for 'Water' and 'Bush' animations
 *        provides the following Actors Notetags/Event Comment Tags:
 *
 *           <WATER STEP: x>
 *              A character with this Notetag will print steps from Block x when
 *              walking on a map region Id marked as 'Water'. 
 *              
 *           <BUSH STEP: x>
 *              A character with this Notetag will print steps from Block x when
 *              walking on a map region Id marked as 'Bush'. 
 *
 *
 *        <NO STEPS>
 *           A character with this Tag will never print steps, 
 *           no matter the region Id. This is useful for flying characters.
 *
 *        <4 LEGS STEPS>
 *           Use this Tag if the character is 4 legged (Ex: Cat). It will
 *           make the foot steps printed in a more aligned arrangement that
 *           fit better a 4 legged creature walking pattern.
 *
 *        <SMALL STEPS>
 *           Foot Steps are printed in their actual size by default. If a
 *           character have this Tag, its Foot Steps will be scaled at 0.5
 *           ratio. This is in the case the character is supposed to be a
 *           small creature that prints smaller foot steps.
 *
 *        <BIG STEPS>
 *           Foot Steps are printed in their actual size by default. If a
 *           character have this Tag, its Foot Steps will be scaled at 1.5
 *           ratio. This is in the case the character is supposed to be a
 *           big creature that prints bigger foot steps.
 *
 *        <STEP SOUNDS x: fileName, volume, pitch, pan>
 *           This Tag can be used to assign a specific step sound to
 *           a character when it walk on a region Id marked for Block x.
 *
 *              Example:
 *                      <STEP SOUND 4: Water3, 50, 100, 0>
 *
 *              A character with this Tag, will play the SE 'Water3' at
 *              volume 50, pitch 100 and pan 0, when it walk on a region
 *              Id marked for Block index 4. This Block is assigned to
 *              the 'Water' step animation through parameters. Hence, the
 *              character would play this sound when walking on Water areas,
 *              instead of the sound set in the Water step anim parameters.
 *
 *
 *
 * ANIMATED STEPS
 * =======================================================================================
 * The Plugin provides 8 parameter step animation sections. Each of them
 * can assign a Block from the sprite sheet and turn it into an Animated
 * Block.
 *
 * The various parameter settings for Animated Blocks are explained in the
 * Parameters section bellow. But the 2 main parameters for the Step Anim
 * are the 'Name' and 'Block' params.
 *
 * The 'Name' is what will be used in the Map, Actors and Events Notetags.
 * The 'Block' is the sprite sheet Block assigned for the animation.
 *
 *
 *   WATER
 *   =====
 *   The Plugin comes with a Plug & Play step animation for watery areas.
 *   It use the first and second Step Anim Parameters Section. The 'Name'
 *   is 'Water' so it provides the following Notetags as explained above.
 *
 *             Map Notetags:  <WATER REGIONS: x, y, z>
 *
 *                         * x, y, and z are Map Region Id
 * 
 *
 *      Actors Notetags or
 *      Events Comment Tags:  <WATER STEP: x>
 *
 *                         * x is sprite sheet Block replacing 
 *                           Water animation when walking on 
 *                           region Id marked as 'Water'
 *
 *
 *    The Water step animation use 2 Blocks from the sprite sheet. The
 *    first one use Block index 4 and is the main animation used for
 *    setting Map, Actors and Events Notetags. The second animation use
 *    Block index 5 and is automatically played as an overlay animation
 *    above the first one. This is defined by the first step animation 
 *    parameters, as explained bellow.
 *
 *
 *   BUSH
 *   =====
 *   The Plugin comes with a Plug & Play step animation for bush tiles.
 *   It use the third Step Anim Parameters Section. The 'Name' is 'Bush'
 *   so it provides the following Notetags as explained above.
 *
 *             Map Notetags:  <BUSH REGIONS: x, y, z>
 *
 *                         * x, y, and z are Map Region Id
 * 
 *
 *      Actors Notetags or
 *      Events Comment Tags:  <BUSH STEP: x>
 *
 *                         * x is the sprite sheet Block replacing 
 *                           Bush animation when walking on region
 *                           Id marked as 'Bush'
 *
 *
 *   HUE
 *   ===
 *   Step animations can be played at a defined hue value. This is
 *   specific to region Id. Hue values can be assigned to regions
 *   Id by adding the hue value between brackets, following the
 *   region Id in the Map Notetags.
 *
 *      Example:    
 *                  <BUSH REGIONS: x, y(310)>
 *
 *         The Bush animation will be played at normal hue when
 *         in region Id x, and at hue 310 when in regionId y.
 *         
 *   Try it for yourself. Place a regular (green) Bush tiles area
 *   on the map and mark it as region x. Then place another Bush
 *   area using the dry (brownish) Bush tiles, and mark it as 
 *   region y. Then place the above Notetags in the Map note box.
 *   The Bush step animation, which is green on the sprite sheet,
 *   will take a more yellow-brown color tone (hue 310) when Actors
 *   and Events walk on region y; to fit better the dry Bush tiles.
 *
 *
 *
 * PARAMETERS
 * =======================================================================================
 * 
 *   -Foot Steps ID
 *      The fist parameter is used to defined if you're using either
 *      region Id or Terrain Tag for identifying the foot steps areas.
 * 
 * 
 * Base Foot Steps
 * ===============
 * 
 *   -Base Steps Block
 *       This parameter set the sprite sheet default Block index 
 *       for 'Foot Steps' and 'Wet Steps' regions.
 *
 *   -Only Last Follower
 *       If this parameter is toggled ON, only the last follower
 *       of the party will print steps in addition to the player.
 *
 *   -Base Opacity
 *       Opacity of foot steps is decreased by this value each
 *       frames, until faded out. Set it to 0 to disable foot
 *       steps fading out.
 *
 *   -Base Duration
 *       This is the maximum duration in frames the foot steps
 *       can remains on screen.
 *
 *   -Foot Steps Sound
 *       This is the sound to be played along with base foot steps.
 *       It will affect all non animated foot steps, so it is more
 *       recommanded to set specific sound to actor and event using
 *       Notetags.
 * 
 *       Sounds must be imported in /audio/se in both ogg and mp4 
 *       format. Enter the file name (without extension), the volu-
 *       me, the pitch and the pan values, separated by commas.
 *
 *          Example: Attack2, 75, 100, 0
 *
 *            *only the SE file name is required. Other arguments
 *             can be omitted as they will receive a default value.
 *
 *
 *
 * Animated Steps
 * ==============
 * The animated steps parameters are separated in 8 sections. Each
 * section allow to turn a Block from the sprite sheet into a step
 * animation. The 3 first sections have default plugin parameters
 * to provide 'Water' and 'Bush' animations as Plug & Play.
 *
 * You can change the default animation settings or create your own
 * custom step animation by filling the parameters of a step anim
 * section, as described bellow.
 *
 *
 *   -Name
 *      This is the name of the animation. The Name define the note-
 *      tags that can be used.
 *
 *         Example:
 *                   Map Notetags:  <'name' regions: x, y, z>                              
 *
 *                    * x, y, and z are Map Region Id assigned
 *                      to the 'name' animation
 *
 *
 *                   Actor Notetags     <'name' step: x>
 *                   & Events comment
 *                   Tags
 *
 *                    * x is sprite sheet Block replacing 
 *                      'name' animation when walking on 
 *                      region Id marked as 'Name'
 *
 *
 *   -Block
 *      This is the sprite sheet Block index that will be used by the
 *      animation.
 *
 *
 *   -Duration
 *      This is the maximum duration of the step animation in frames.
 *
 *
 *   -Straight Steps
 *      When set to true, the step animation will be printed in a straight
 *      manner, similar to the effect of the <4 legs steps> notetag. This
 *      works well for the Bush animation, for instance.
 *
 *
 *   -Step Under
 *      This make the step animation appears directly under the character,
 *      rather than a little bit behind. Again, this works well for the
 *      Bush animation.
 *
 *
 *   -Start Index
 *      Normally, the step animation start at index 0 (top left frame in
 *      a Block), but it can be changed to accomodate specific needs.*
 *
 *
 *   -End Index
 *      Normally, the step animation end at index 11 (bottom right frame 
 *      in a Block), but it can be changed to accomodate specific needs.*
 *
 *         *This means you can theorically makes 2 step animations out
 *          of the same Block by assigning 2 step animations parameter
 *          sections to the same Block, but with different Start and
 *          End Index.
 *
 *            Example:
 *                     anim 1: startIndex = 0, EndIndex = 5
 *                     anim 2: startIndex = 6, EndIndex = 11
 *
 *
 *   -Frame Rate
 *      This is the frame rate of the step animation. Must be correlated
 *      with the step animation duration, otherwise part of the animation
 *      might be cut off.
 *
 *
 *   -Opacity Rate
 *      This is the rate at which the foot steps opacity fade out.
 *
 *
 *   -Loop Type
 *      You can choose between 3 loop type for your step animations:
 *
 *       1) no loop:        Step animation terminate when it reach the
 *                          last frame, no matter the duration left.
 *
 *       2) loop:           Step animation will keep looping until
 *                          duration is over.
 *  
 *       3) stay on last:   Step animation will stay on the last frame
 *                          until the duration is over.
 *
 *
 *   -Rotate
 *      When this parameter is toggled ON, the step animation will 
 *      rotate according to the character direction. The sprites of
 *      your step animation Block must be drawn facing up on the 
 *      sprite sheet, so the rotation fits the character direction.
 *      Good example of this is the default Bush animation.
 *
 *
 *   -Second Block
 *      This is to assign a second step animation Block to be played
 *      as an overlay animation. The second step anim will play over
 *      the current one, according to its own settings defined in the 
 *      corresponding step animation parameters section. Good example 
 *      of this is the default Water animation.      
 *
 *
 *   -Wet feet
 *      This is to set if the characters will leaves wet foot steps
 *      on 3 tiles after leaving the area that prints the animation.
 *      Good example of this is the default Water animation.
 *   
 *
 *   -Over Anim
 *      This parameter is only valid when the step animation is used
 *      as a second animation. In that case, you can decide if the
 *      second animation is played under OR above the characters.
 *
 *
 *   -Sound
 *      This is to set the sound effect that will be played along with
 *      the animation. Enter the file name without extension, and if
 *      needed, the volume, the pitch and the pan separated by commas.
 *      
 *         Example: Move1, 30, 130, 0
 *                  
 *            *only the SE file name is required. Other arguments
 *             can be omitted as they will receive a default value.
 * 
 *
 *
 * =======================================================================================
 * == Terms of usage =====================================================================
 * =======================================================================================
 * 
 * Use in any independant RPG Maker MZ or MV projects, including commercials.
 *
 * Credit is required for using this Plugin. 
 * For crediting, use 'TSR' along with one of
 * the following terms: 
 *      'The Northern Frog' or 'A frog from the north'
 * 
 * Do not change the Header or the Terms of usage.
 *
 * DO NOT REDISTRIBUTE!
 * If you want to share it, share the link to my itch.io account: 
 * https://the-northern-frog.itch.io/
 * 
 * SPRITE SHEET
 * The FootSteps.png sprite sheet is free to download on my itchi.io 
 * account. Editing it to your liking is permited and no credit is asked  
 * for using it. But it shouldn't be used in games that don't use this 
 * plugin, nor in a game not made with RPG Maker MZ or MV.
 *
 * SPECIAL THANKS
 * Thanks to ShadowDragon for testing and bugs report.
 *
 *
 * =======================================================================================
 * == Version and compatibility ==========================================================
 * =======================================================================================
 * 2020/09/18 Prototype version completed, v0.1.3
 * 2020/09/19 Add notetags object processing and adjust script accordingly, v0.2.3
 * 2020/09/20 Add step sounds and parameters, v0.3.4
 * 2020/09/21 Completed parameters, and add step scaling and sounds adjusting, v1.3.5
 * 2020/09/26 Add more parameters for step anim, v1.3.6
 * 2020/09/27 Add map scroll update to foot step sprites, v1.3.7
 * 2020/11/23 Conversion for RPG Maker MZ v1.3.8
 * 2021/02/19 Add reflection steps to work with TSR_Mirror and minor fixes v1.4.0
 * 2021/07/27 Add terrain Tag Id and turning off animation for stepAnim blocks v1.4.2
 *
 * =======================================================================================
 * == END ================================================================================                                             
 * =======================================================================================
 *
 *                              "Have fun!"
 *                                                  TSR, The Northern Frog
 *
 * =======================================================================================
 *
 *
 * @param Foot Steps ID
 * @type combo
 * @option region Id
 * @option terrain Tag
 * @desc Choose the tag Id for marking the foot steps on the map.
 * region Id - terrain Tag
 * @default region Id
 * 
 * 
 *@param ---Base Foot Steps---
 *
 * @param Base Steps Block
 * @parent ---Base Foot Steps---
 * @type number
 * @min 0
 * @desc The default block for base foot steps.
 * Default: 0
 * @default 0
 *
 * @param Only Last Follower
 * @parent ---Base Foot Steps---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc On the last follower prints steps?
 * OFF - false  ON - true
 * @default false
 *
 * @param Base Opacity
 * @parent ---Base Foot Steps---
 * @type number
 * @min 0
 * @desc The base opacity decrement of foot steps.
 * Default: 4
 * @default 4
 *
 * @param Base Duration
 * @parent ---Base Foot Steps---
 * @type number
 * @min 0
 * @desc The base duration of foot steps in frames.
 * Default: 60
 * @default 60
 *
 * @param Foot Steps Sound
 * @parent ---Base Foot Steps---
 * @desc Enter file name of the default foot step sound.
 * Default:
 * @default
 *
 *
 *@param ---Foot Step Anim 1---
 *
 * @param Anim 1 Name
 * @parent ---Foot Step Anim 1---
 * @desc Name of the Anim Step.
 * Default: Water
 * @default Water
 *
 * @param Anim 1 Block
 * @parent ---Foot Step Anim 1---
 * @type number
 * @min 0
 * @desc Sprite sheet Block used by the anim.
 * Default: 4
 * @default 4
 *
 * @param Anim 1 Duration
 * @parent ---Foot Step Anim 1---
 * @type number
 * @min 0
 * @desc The duration of this step anim.
 * Default: 60
 * @default 60
 *
 * @param Anim 1 Straight Steps
 * @parent ---Foot Step Anim 1---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed in a straight way?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 1 Step Under
 * @parent ---Foot Step Anim 1---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed directly under the character?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 1 Start Index
 * @parent ---Foot Step Anim 1---
 * @type number
 * @min 0
 * @max 11
 * @desc The starting index inside the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 1 End Index
 * @parent ---Foot Step Anim 1---
 * @type number
 * @min 0
 * @max 11
 * @desc The last index of the block for the anim.
 * Default: 11
 * @default 11
 *
 * @param Anim 1 Frame Rate
 * @parent ---Foot Step Anim 1---
 * @type number
 * @min 0
 * @desc The frame rate for the anim.
 * Default: 4
 * @default 4
 *
 * @param Anim 1 Opacity Rate
 * @parent ---Foot Step Anim 1---
 * @type number
 * @min 0
 * @desc Set the foot steps opacity decrement by frame.
 * Default: 4
 * @default 4
 *
 * @param Anim 1 Loop Type
 * @parent ---Foot Step Anim 1---
 * @type combo
 * @option loop
 * @option no loop
 * @option stay on last frame
 * @desc Choose the loop type for the anim.
 * loop - no loop - stay on last frame
 * @default no loop
 *
 * @param Anim 1 Rotate
 * @parent ---Foot Step Anim 1---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Rotate the sprite with characters direction?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 1 Wet Feet
 * @parent ---Foot Step Anim 1---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Leave wet feet prints when leaving the Anim?
 * OFF - false  ON - true
 * @default true
 *
 * @param Anim 1 Second Block
 * @parent ---Foot Step Anim 1---
 * @type number
 * @min 0
 * @desc Index of the Block for second Anim. 0 for none.
 * Default: 5
 * @default 5
 *
 * @param Anim 1 Over Anim
 * @parent ---Foot Step Anim 1---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Anim is play above characters?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 1 Sound
 * @parent ---Foot Step Anim 1---
 * @desc File name, volume, pitch and pan of the anim sound.
 * Default: Water2, 35, 130, 0
 * @default Water2, 35, 130, 0
 *
 *
 *@param ---Foot Step Anim 2---
 *
 * @param Anim 2 Name
 * @parent ---Foot Step Anim 2---
 * @desc Name of the Anim Step.
 * Default: Water Overlay
 * @default Water Overlay
 *
 * @param Anim 2 Block
 * @parent ---Foot Step Anim 2---
 * @type number
 * @min 0
 * @desc Sprite sheet Block used by the anim.
 * Default: 5
 * @default 5
 *
 * @param Anim 2 Duration
 * @parent ---Foot Step Anim 2---
 * @type number
 * @min 0
 * @desc The duration of this step anim.
 * Default: 60
 * @default 60
 *
 * @param Anim 2 Straight Steps
 * @parent ---Foot Step Anim 2---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed in a straight way?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 2 Step Under
 * @parent ---Foot Step Anim 2---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed directly under the character?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 2 Start Index
 * @parent ---Foot Step Anim 2---
 * @type number
 * @min 0
 * @max 11
 * @desc The starting index inside the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 2 End Index
 * @parent ---Foot Step Anim 2---
 * @type number
 * @min 0
 * @max 11
 * @desc The last index of the block for the anim.
 * Default: 11
 * @default 11
 *
 * @param Anim 2 Frame Rate
 * @parent ---Foot Step Anim 2---
 * @type number
 * @min 0
 * @desc The frame rate for the anim.
 * Default: 4
 * @default 4
 *
 * @param Anim 2 Opacity Rate
 * @parent ---Foot Step Anim 2---
 * @type number
 * @min 0
 * @desc Set the foot steps opacity decrement by frame.
 * Default: 4
 * @default 4
 *
 * @param Anim 2 Loop Type
 * @parent ---Foot Step Anim 2---
 * @type combo
 * @option loop
 * @option no loop
 * @option stay on last frame
 * @desc Choose the loop type for the anim.
 * loop - no loop - stay on last frame
 * @default no loop
 *
 * @param Anim 2 Rotate
 * @parent ---Foot Step Anim 2---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Rotate the sprite with characters direction?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 2 Wet Feet
 * @parent ---Foot Step Anim 2---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Leave wet feet prints when leaving the Anim?
 * OFF - false  ON - true
 * @default true
 *
 * @param Anim 2 Second Block
 * @parent ---Foot Step Anim 2---
 * @type number
 * @min 0
 * @desc Index of the Block for second Anim. 0 for none.
 * Default: 0
 * @default 0
 *
 * @param Anim 2 Over Anim
 * @parent ---Foot Step Anim 2---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Anim is play above characters?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 2 Sound
 * @parent ---Foot Step Anim 2---
 * @desc File name, volume, pitch and pan of the anim sound.
 * Default: 
 * @default 
 *
 *
 *@param ---Foot Step Anim 3---
 *
 * @param Anim 3 Name
 * @parent ---Foot Step Anim 3---
 * @desc Name of the Anim Step.
 * Default: Bush
 * @default Bush
 *
 * @param Anim 3 Block
 * @parent ---Foot Step Anim 3---
 * @type number
 * @min 0
 * @desc Sprite sheet Block used by the anim.
 * Default: 6
 * @default 6
 *
 * @param Anim 3 Duration
 * @parent ---Foot Step Anim 3---
 * @type number
 * @min 0
 * @desc The duration of this step anim.
 * Default: 60
 * @default 60
 *
 * @param Anim 3 Straight Steps
 * @parent ---Foot Step Anim 3---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed in a straight way?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 3 Step Under
 * @parent ---Foot Step Anim 3---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed directly under the character?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 3 Start Index
 * @parent ---Foot Step Anim 3---
 * @type number
 * @min 0
 * @max 11
 * @desc The starting index inside the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 3 End Index
 * @parent ---Foot Step Anim 3---
 * @type number
 * @min 0
 * @max 11
 * @desc The last index of the block for the anim.
 * Default: 11
 * @default 11
 *
 * @param Anim 3 Frame Rate
 * @parent ---Foot Step Anim 3---
 * @type number
 * @min 0
 * @desc The frame rate for the anim.
 * Default: 4
 * @default 4
 *
 * @param Anim 3 Opacity Rate
 * @parent ---Foot Step Anim 3---
 * @type number
 * @min 0
 * @desc Set the foot steps opacity decrement by frame.
 * Default: 4
 * @default 4
 *
 * @param Anim 3 Loop Type
 * @parent ---Foot Step Anim 3---
 * @type combo
 * @option loop
 * @option no loop
 * @option stay on last frame
 * @desc Choose the loop type for the anim.
 * loop - no loop - stay on last frame
 * @default no loop
 *
 * @param Anim 3 Rotate
 * @parent ---Foot Step Anim 3---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Rotate the sprite with characters direction?
 * OFF - false  ON - true
 * @default true
 *
 * @param Anim 3 Wet Feet
 * @parent ---Foot Step Anim 3---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Leave wet feet prints when leaving the Anim?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 3 Second Block
 * @parent ---Foot Step Anim 3---
 * @type number
 * @min 0
 * @desc Index of the Block for second Anim. 0 for none.
 * Default: 0
 * @default 0
 *
 * @param Anim 3 Over Anim
 * @parent ---Foot Step Anim 3---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Anim is play above characters?
 * OFF - false  ON - true
 * @default true
 *
 * @param Anim 3 Sound
 * @parent ---Foot Step Anim 3---
 * @desc File name, volume, pitch and pan of the anim sound.
 * Default: Wind1, 35, 110, 0
 * @default Wind1, 35, 110, 0
 *
 *
 *@param ---Foot Step Anim 4---
 *
 * @param Anim 4 Name
 * @parent ---Foot Step Anim 4---
 * @desc Name of the Anim Step.
 * Default:
 * @default
 *
 * @param Anim 4 Block
 * @parent ---Foot Step Anim 4---
 * @type number
 * @min 0
 * @desc Sprite sheet Block used by the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 4 Duration
 * @parent ---Foot Step Anim 4---
 * @type number
 * @min 0
 * @desc The duration of this step anim.
 * Default: 60
 * @default 60
 *
 * @param Anim 4 Straight Steps
 * @parent ---Foot Step Anim 4---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed in a straight way?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 4 Step Under
 * @parent ---Foot Step Anim 4---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed directly under the character?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 4 Start Index
 * @parent ---Foot Step Anim 4---
 * @type number
 * @min 0
 * @max 11
 * @desc The starting index inside the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 4 End Index
 * @parent ---Foot Step Anim 4---
 * @type number
 * @min 0
 * @max 11
 * @desc The last index of the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 4 Frame Rate
 * @parent ---Foot Step Anim 4---
 * @type number
 * @min 0
 * @desc The frame rate for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 4 Opacity Rate
 * @parent ---Foot Step Anim 4---
 * @type number
 * @min 0
 * @desc Set the foot steps opacity decrement by frame.
 * Default: 0
 * @default 0
 *
 * @param Anim 4 Loop Type
 * @parent ---Foot Step Anim 4---
 * @type combo
 * @option loop
 * @option no loop
 * @option stay on last frame
 * @desc Choose the loop type for the anim.
 * loop - no loop - stay on last frame
 * @default no loop
 *
 * @param Anim 4 Rotate
 * @parent ---Foot Step Anim 4---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Rotate the sprite with characters direction?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 4 Wet Feet
 * @parent ---Foot Step Anim 4---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Leave wet feet prints when leaving the Anim?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 4 Second Block
 * @parent ---Foot Step Anim 4---
 * @type number
 * @min 0
 * @desc Index of the Block for second Anim. 0 for none.
 * Default: 0
 * @default 0
 *
 * @param Anim 4 Over Anim
 * @parent ---Foot Step Anim 4---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Anim is play above characters?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 4 Sound
 * @parent ---Foot Step Anim 4---
 * @desc File name, volume, pitch and pan of the anim sound.
 * Default: 
 * @default 
 *
 *
 *@param ---Foot Step Anim 5---
 *
 * @param Anim 5 Name
 * @parent ---Foot Step Anim 5---
 * @desc Name of the Anim Step.
 * Default:
 * @default
 *
 * @param Anim 5 Block
 * @parent ---Foot Step Anim 5---
 * @type number
 * @min 0
 * @desc Sprite sheet Block used by the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 5 Duration
 * @parent ---Foot Step Anim 5---
 * @type number
 * @min 0
 * @desc The duration of this step anim.
 * Default: 60
 * @default 60
 *
 * @param Anim 5 Straight Steps
 * @parent ---Foot Step Anim 5---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed in a straight way?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 5 Step Under
 * @parent ---Foot Step Anim 5---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed directly under the character?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 5 Start Index
 * @parent ---Foot Step Anim 5---
 * @type number
 * @min 0
 * @max 11
 * @desc The starting index inside the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 5 End Index
 * @parent ---Foot Step Anim 5---
 * @type number
 * @min 0
 * @max 11
 * @desc The last index of the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 5 Frame Rate
 * @parent ---Foot Step Anim 5---
 * @type number
 * @min 0
 * @desc The frame rate for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 5 Opacity Rate
 * @parent ---Foot Step Anim 5---
 * @type number
 * @min 0
 * @desc Set the foot steps opacity decrement by frame.
 * Default: 0
 * @default 0
 *
 * @param Anim 5 Loop Type
 * @parent ---Foot Step Anim 5---
 * @type combo
 * @option loop
 * @option no loop
 * @option stay on last frame
 * @desc Choose the loop type for the anim.
 * loop - no loop - stay on last frame
 * @default no loop
 *
 * @param Anim 5 Rotate
 * @parent ---Foot Step Anim 5---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Rotate the sprite with characters direction?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 5 Wet Feet
 * @parent ---Foot Step Anim 5---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Leave wet feet prints when leaving the Anim?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 5 Second Block
 * @parent ---Foot Step Anim 5---
 * @type number
 * @min 0
 * @desc Index of the Block for second Anim. 0 for none.
 * Default: 0
 * @default 0
 *
 * @param Anim 5 Over Anim
 * @parent ---Foot Step Anim 5---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Anim is play above characters?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 5 Sound
 * @parent ---Foot Step Anim 5---
 * @desc File name, volume, pitch and pan of the anim sound.
 * Default: 
 * @default 
 *
 *
 *@param ---Foot Step Anim 6---
 *
 * @param Anim 6 Name
 * @parent ---Foot Step Anim 6---
 * @desc Name of the Anim Step.
 * Default:
 * @default
 *
 * @param Anim 6 Block
 * @parent ---Foot Step Anim 6---
 * @type number
 * @min 0
 * @desc Sprite sheet Block used by the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 6 Duration
 * @parent ---Foot Step Anim 6---
 * @type number
 * @min 0
 * @desc The duration of this step anim.
 * Default: 60
 * @default 60
 *
 * @param Anim 6 Straight Steps
 * @parent ---Foot Step Anim 6---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed in a straight way?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 6 Step Under
 * @parent ---Foot Step Anim 6---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed directly under the character?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 6 Start Index
 * @parent ---Foot Step Anim 6---
 * @type number
 * @min 0
 * @max 11
 * @desc The starting index inside the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 6 End Index
 * @parent ---Foot Step Anim 6---
 * @type number
 * @min 0
 * @max 11
 * @desc The last index of the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 6 Frame Rate
 * @parent ---Foot Step Anim 6---
 * @type number
 * @min 0
 * @desc The frame rate for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 6 Opacity Rate
 * @parent ---Foot Step Anim 6---
 * @type number
 * @min 0
 * @desc Set the foot steps opacity decrement by frame.
 * Default: 0
 * @default 0
 *
 * @param Anim 6 Loop Type
 * @parent ---Foot Step Anim 6---
 * @type combo
 * @option loop
 * @option no loop
 * @option stay on last frame
 * @desc Choose the loop type for the anim.
 * loop - no loop - stay on last frame
 * @default no loop
 *
 * @param Anim 6 Rotate
 * @parent ---Foot Step Anim 6---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Rotate the sprite with characters direction?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 6 Wet Feet
 * @parent ---Foot Step Anim 6---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Leave wet feet prints when leaving the Anim?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 6 Second Block
 * @parent ---Foot Step Anim 6---
 * @type number
 * @min 0
 * @desc Index of the Block for second Anim. 0 for none.
 * Default: 0
 * @default 0
 *
 * @param Anim 6 Over Anim
 * @parent ---Foot Step Anim 6---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Anim is play above characters?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 6 Sound
 * @parent ---Foot Step Anim 6---
 * @desc File name, volume, pitch and pan of the anim sound.
 * Default: 
 * @default 
 *
 *
 *@param ---Foot Step Anim 7---
 *
 * @param Anim 7 Name
 * @parent ---Foot Step Anim 7---
 * @desc Name of the Anim Step.
 * Default:
 * @default
 *
 * @param Anim 7 Block
 * @parent ---Foot Step Anim 7---
 * @type number
 * @min 0
 * @desc Sprite sheet Block used by the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 7 Duration
 * @parent ---Foot Step Anim 7---
 * @type number
 * @min 0
 * @desc The duration of this step anim.
 * Default: 60
 * @default 60
 *
 * @param Anim 7 Straight Steps
 * @parent ---Foot Step Anim 7---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed in a straight way?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 7 Step Under
 * @parent ---Foot Step Anim 7---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed directly under the character?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 7 Start Index
 * @parent ---Foot Step Anim 7---
 * @type number
 * @min 0
 * @max 11
 * @desc The starting index inside the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 7 End Index
 * @parent ---Foot Step Anim 7---
 * @type number
 * @min 0
 * @max 11
 * @desc The last index of the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 7 Frame Rate
 * @parent ---Foot Step Anim 7---
 * @type number
 * @min 0
 * @desc The frame rate for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 7 Opacity Rate
 * @parent ---Foot Step Anim 7---
 * @type number
 * @min 0
 * @desc Set the foot steps opacity decrement by frame.
 * Default: 0
 * @default 0
 *
 * @param Anim 7 Loop Type
 * @parent ---Foot Step Anim 7---
 * @type combo
 * @option loop
 * @option no loop
 * @option stay on last frame
 * @desc Choose the loop type for the anim.
 * loop - no loop - stay on last frame
 * @default no loop
 *
 * @param Anim 7 Rotate
 * @parent ---Foot Step Anim 7---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Rotate the sprite with characters direction?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 7 Wet Feet
 * @parent ---Foot Step Anim 7---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Leave wet feet prints when leaving the Anim?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 7 Second Block
 * @parent ---Foot Step Anim 7---
 * @type number
 * @min 0
 * @desc Index of the Block for second Anim. 0 for none.
 * Default: 0
 * @default 0
 *
 * @param Anim 7 Over Anim
 * @parent ---Foot Step Anim 7---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Anim is play above characters?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 7 Sound
 * @parent ---Foot Step Anim 7---
 * @desc File name, volume, pitch and pan of the anim sound.
 * Default: 
 * @default 
 *
 *
 *@param ---Foot Step Anim 8---
 *
 * @param Anim 8 Name
 * @parent ---Foot Step Anim 8---
 * @desc Name of the Anim Step.
 * Default:
 * @default
 *
 * @param Anim 8 Block
 * @parent ---Foot Step Anim 8---
 * @type number
 * @min 0
 * @desc Sprite sheet Block used by the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 8 Duration
 * @parent ---Foot Step Anim 8---
 * @type number
 * @min 0
 * @desc The duration of this step anim.
 * Default: 60
 * @default 60
 *
 * @param Anim 8 Straight Steps
 * @parent ---Foot Step Anim 8---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed in a straight way?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 8 Step Under
 * @parent ---Foot Step Anim 8---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Step anim are printed directly under the character?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 8 Start Index
 * @parent ---Foot Step Anim 8---
 * @type number
 * @min 0
 * @max 11
 * @desc The starting index inside the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 8 End Index
 * @parent ---Foot Step Anim 8---
 * @type number
 * @min 0
 * @max 11
 * @desc The last index of the block for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 8 Frame Rate
 * @parent ---Foot Step Anim 8---
 * @type number
 * @min 0
 * @desc The frame rate for the anim.
 * Default: 0
 * @default 0
 *
 * @param Anim 8 Opacity Rate
 * @parent ---Foot Step Anim 8---
 * @type number
 * @min 0
 * @desc Set the foot steps opacity decrement by frame.
 * Default: 0
 * @default 0
 *
 * @param Anim 8 Loop Type
 * @parent ---Foot Step Anim 8---
 * @type combo
 * @option loop
 * @option no loop
 * @option stay on last frame
 * @desc Choose the loop type for the anim.
 * loop - no loop - stay on last frame
 * @default no loop
 *
 * @param Anim 8 Rotate
 * @parent ---Foot Step Anim 8---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Rotate the sprite with characters direction?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 8 Wet Feet
 * @parent ---Foot Step Anim 8---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Leave wet feet prints when leaving the Anim?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 8 Second Block
 * @parent ---Foot Step Anim 8---
 * @type number
 * @min 0
 * @desc Index of the Block for second Anim. 0 for none.
 * Default: 0
 * @default 0
 *
 * @param Anim 8 Over Anim
 * @parent ---Foot Step Anim 8---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Anim is play above characters?
 * OFF - false  ON - true
 * @default false
 *
 * @param Anim 8 Sound
 * @parent ---Foot Step Anim 8---
 * @desc File name, volume, pitch and pan of the anim sound.
 * Default: 
 * @default 
 *
 *
 *
 */

 (() => {
const _0x76bf=['Anim\x202\x20Wet\x20Feet','Anim\x201\x20Block','TSR_Mirror','Anim\x201\x20Step\x20Under','wet\x20step','setStepAnimFrame','_stepBlock','Anim\x206\x20Start\x20Index','Anim\x203\x20Wet\x20Feet','Anim\x203\x20Sound','_Sprite_Character_update','Anim\x201\x20Rotate','Anim\x203\x20Block','Anim\x208\x20Wet\x20Feet','_scene','floor','Anim\x204\x20Step\x20Under','Anim\x204\x20Name','baseBlock','Anim\x205\x20Sound','Anim\x204\x20Second\x20Block','Anim\x208\x20Second\x20Block','Parameters','Anim\x201\x20Over\x20Anim','Anim\x201\x20Frame\x20Rate','requestfootSteps','terrainTag','visible','setSecondStepHpos','anim1_Snd','Anim\x201\x20Duration','bitmap','_realY','rotate','_stepOverAnim','trim','_noBlock','stepUnder','regionId','Anim\x207\x20Wet\x20Feet','_wetFeet','_displayY','_dashing','Anim\x207\x20Frame\x20Rate','createFootStepSprite','_footStepsSprite','keys','page','Anim\x202\x20End\x20Index','Anim\x205\x20Over\x20Anim','endIndex','_stepFrame','anim5_Snd','Anim\x207\x20Loop\x20Type','_Spriteset_Map_createLowerLayer','99995BLxLHh','Anim\x206\x20Opacity\x20Rate','_animatedStep','Anim\x204\x20Rotate','fct','getCombo','anim3_Snd','Anim\x201\x20Straight\x20Steps','animBlock','_tilemap','Anim\x201\x20Start\x20Index','_stepUnder','leader','_anim','no\x20loop','1PUhnAB','_goLeft','rotation','anchor','_reflectfirstDash','_animLoop','Anim\x207\x20Name','Anim\x203\x20Over\x20Anim','noBlock','removeChild','_speed','Base\x20Opacity','makeBlock','_followers','setFrame','abs','Anim\x208\x20Frame\x20Rate','createLowerLayer','Anim\x205\x20Frame\x20Rate','_defaultBlock','isLeavingUnwetAnim','_visible','_animRate','_spriteset','anim8_Snd','Anim\x206\x20Step\x20Under','Anim\x202\x20Second\x20Block','_stepHue','setup','Anim\x203\x20Frame\x20Rate','_anim6','Anim\x202\x20Block','block_x','isPlaying','Anim\x206\x20Block','_anim2','tag','slice','loadSystem','loadBitmap','_lastDisplayX','_wetFeetCount','_rate','Anim\x204\x20Duration','moveSpeed','695083bQKWAl','Anim\x202\x20Name','_anim8','_stepWait','playSe','_animStep','toLowerCase','_loaded','_Game_Event_setupPage','shift','DataManager_isDatabaseLoaded','_sound','update','parameters','setupFootSteps','cachePitch','_actorId','loop','straight','tileWidth','updateFootStepAnim','Anim\x203\x20Duration','stepFrameIndex','_wetRegion','34236jIVxaP','Anim\x202\x20Rotate','Anim\x205\x20End\x20Index','setupPage','Anim\x202\x20Frame\x20Rate','name','indexOf','Anim\x206\x20Sound','Anim\x205\x20Duration','prototype','_memberIndex','apply','isAnim','isFootPrintRegionId','1667119vKrlMJ','split','_spriteOverAnim','_onlyLastFollower','isLeavingAnim','Anim\x208\x20Block','Anim\x204\x20Over\x20Anim','Anim\x203\x20Opacity\x20Rate','preloadStepSounds','adjustSound','createStepOverAnim','Anim\x204\x20Frame\x20Rate','anim7_Snd','Anim\x202\x20Straight\x20Steps','scale','Block','Base\x20Steps\x20Block','constructor','anim4_Snd','Anim\x204\x20Loop\x20Type','Anim\x203\x20End\x20Index','Anim\x205\x20Name','setStepBlock','_duration','distance','Anim\x206\x20Over\x20Anim','Anim\x205\x20Block','createStepSprite','Anim\x207\x20Over\x20Anim','pitch','Anim\x206\x20Straight\x20Steps','527979fDNPhS','Anim\x206\x20End\x20Index','_secondAnim','checkFootStepTag','animated','1211396SNsiyG','block','Anim\x202\x20Sound','Anim\x204\x20Wet\x20Feet','terrain\x20Tag','_baseBlock','addChild','loadStepSound','over','Anim\x203\x20Name','_tileWidth','3rcRXpT','_overAnim','block_y','Anim\x203\x20Start\x20Index','_animDash','height','Anim\x203\x20Second\x20Block','note','sound','Anim\x203\x20Straight\x20Steps','width','1637559MFcSeg','Anim\x208\x20Start\x20Index','Anim\x206\x20Name','Anim\x208\x20Duration','footStep','Anim\x205\x20Wet\x20Feet','first','11uXTNDp','_animationCount','Anim\x205\x20Straight\x20Steps','distToBottomMirror','inFrontOfMirror','wet','battleMembers','anim2_Snd','Anim\x208\x20Rotate','volume','push','_anim7','isDatabaseLoaded','_baseOpacity','Anim\x202\x20Opacity\x20Rate','Anim\x207\x20Straight\x20Steps','_stepdir','frameRate','Anim\x204\x20End\x20Index','_footStepsId','step','contains','Anim\x208\x20Step\x20Under','_animList','Anim\x202\x20Start\x20Index','Anim\x201\x20Loop\x20Type','_reflectionSteps','_4legs','_realX','footStepsId','Anim\x208\x20Opacity\x20Rate','getAngle','_scaleStep','startFootSteps','opacity','_anim4','_baseDuration','Anim\x203\x20Step\x20Under','Anim\x201\x20End\x20Index','_anim3','Anim\x208\x20Loop\x20Type','Anim\x205\x20Step\x20Under','readActorsFootStepTag','Anim\x206\x20Frame\x20Rate','Anim\x201\x20Sound','initialize','_lastDisplayY','Anim\x202\x20Step\x20Under','match','_type','initMembers','stepBlock','Anim\x206\x20Duration','setSecondStepVpos','_followerStep','27vXGggD','loadSystemImages','_hasFadeIn','Base\x20Duration','anim6_Snd','Anim\x205\x20Opacity\x20Rate','Anim\x207\x20Rotate','_anim5','loadStaticSe','_baseSound','getSpeedFactor','moveStraight','_stepFrameIndex','length','_reflection','_opRate','_Sprite_Character_initMembers','size','call','Anim\x205\x20Rotate','isNextBlockAnim','_anim1','_tagId','updateFootSteps','Anim\x207\x20Duration','_endFrame','makeSoundObj','_character','_displayX','second','region','Anim\x208\x20Name','Anim\x208\x20Straight\x20Steps','setSpritePos','_footStepSprite','Anim\x206\x20Rotate'];function _0x357e(_0x4df826,_0x37048d){return _0x357e=function(_0x76bf31,_0x357eaf){_0x76bf31=_0x76bf31-0x1c6;let _0x4ffd7c=_0x76bf[_0x76bf31];return _0x4ffd7c;},_0x357e(_0x4df826,_0x37048d);}const _0x169035=_0x357e;(function(_0x238d0d,_0x31272e){const _0x561bbf=_0x357e;while(!![]){try{const _0x104b19=parseInt(_0x561bbf(0x255))*parseInt(_0x561bbf(0x245))+-parseInt(_0x561bbf(0x24a))+-parseInt(_0x561bbf(0x2f9))*parseInt(_0x561bbf(0x267))+parseInt(_0x561bbf(0x260))+parseInt(_0x561bbf(0x1d3))*-parseInt(_0x561bbf(0x200))+parseInt(_0x561bbf(0x226))+parseInt(_0x561bbf(0x29e))*-parseInt(_0x561bbf(0x218));if(_0x104b19===_0x31272e)break;else _0x238d0d['push'](_0x238d0d['shift']());}catch(_0x250a84){_0x238d0d['push'](_0x238d0d['shift']());}}}(_0x76bf,0xe9d7b),TSR[_0x169035(0x2d8)]=PluginManager['parameters']('TSR_FootSteps'),TSR['footStep'][_0x169035(0x1c8)]=Object[_0x169035(0x2f0)],TSR[_0x169035(0x264)]['_tagId']=String(TSR[_0x169035(0x2d8)]['Foot\x20Steps\x20ID']),TSR[_0x169035(0x264)]['_defaultBlock']=Number(TSR[_0x169035(0x2d8)][_0x169035(0x236)]),TSR['footStep'][_0x169035(0x229)]=eval(String(TSR[_0x169035(0x2d8)]['Only\x20Last\x20Follower'])),TSR[_0x169035(0x264)]['_baseOpacity']=Number(TSR[_0x169035(0x2d8)][_0x169035(0x1de)]),TSR[_0x169035(0x264)]['_baseDuration']=Number(TSR[_0x169035(0x2d8)][_0x169035(0x2a1)]),TSR[_0x169035(0x264)]['_baseSound']=String(TSR[_0x169035(0x2d8)]['Foot\x20Steps\x20Sound'])[_0x169035(0x227)](','),TSR['footStep'][_0x169035(0x2df)]=String(TSR['Parameters'][_0x169035(0x293)])[_0x169035(0x227)](','),TSR[_0x169035(0x264)][_0x169035(0x26e)]=String(TSR[_0x169035(0x2d8)][_0x169035(0x24c)])[_0x169035(0x227)](','),TSR[_0x169035(0x264)]['anim3_Snd']=String(TSR['Parameters'][_0x169035(0x2cb)])[_0x169035(0x227)](','),TSR[_0x169035(0x264)][_0x169035(0x238)]=String(TSR[_0x169035(0x2d8)]['Anim\x204\x20Sound'])['split'](','),TSR['footStep'][_0x169035(0x2f6)]=String(TSR[_0x169035(0x2d8)][_0x169035(0x2d5)])[_0x169035(0x227)](','),TSR[_0x169035(0x264)][_0x169035(0x2a2)]=String(TSR[_0x169035(0x2d8)][_0x169035(0x21f)])[_0x169035(0x227)](','),TSR[_0x169035(0x264)][_0x169035(0x232)]=String(TSR[_0x169035(0x2d8)]['Anim\x207\x20Sound'])[_0x169035(0x227)](','),TSR[_0x169035(0x264)][_0x169035(0x1eb)]=String(TSR[_0x169035(0x2d8)]['Anim\x208\x20Sound'])[_0x169035(0x227)](','),TSR['footStep'][_0x169035(0x2b8)]=_0x4b06bc=>{const _0x424cb5=_0x169035;let _0x59f9cb=_0x4b06bc[0x0][_0x424cb5(0x2e5)]()||![],_0x42313e=parseInt(_0x4b06bc[0x1])||0x64,_0x577ca1=parseInt(_0x4b06bc[0x2])||0x64,_0x39b13d=parseInt(_0x4b06bc[0x3])||0x0;if(_0x59f9cb)return{'name':_0x59f9cb,'volume':_0x42313e,'pitch':_0x577ca1,'pan':_0x39b13d,'maxVol':_0x42313e,'cachePitch':_0x577ca1};return![];},TSR[_0x169035(0x264)][_0x169035(0x2a7)]=TSR['footStep'][_0x169035(0x2b8)](TSR[_0x169035(0x264)][_0x169035(0x2a7)]),TSR['footStep'][_0x169035(0x2df)]=TSR['footStep'][_0x169035(0x2b8)](TSR['footStep'][_0x169035(0x2df)]),TSR['footStep'][_0x169035(0x26e)]=TSR[_0x169035(0x264)]['makeSoundObj'](TSR['footStep'][_0x169035(0x26e)]),TSR[_0x169035(0x264)]['anim3_Snd']=TSR[_0x169035(0x264)][_0x169035(0x2b8)](TSR[_0x169035(0x264)][_0x169035(0x1ca)]),TSR[_0x169035(0x264)][_0x169035(0x238)]=TSR[_0x169035(0x264)][_0x169035(0x2b8)](TSR[_0x169035(0x264)][_0x169035(0x238)]),TSR[_0x169035(0x264)][_0x169035(0x2f6)]=TSR[_0x169035(0x264)][_0x169035(0x2b8)](TSR['footStep'][_0x169035(0x2f6)]),TSR['footStep'][_0x169035(0x2a2)]=TSR[_0x169035(0x264)]['makeSoundObj'](TSR[_0x169035(0x264)]['anim6_Snd']),TSR['footStep'][_0x169035(0x232)]=TSR[_0x169035(0x264)]['makeSoundObj'](TSR[_0x169035(0x264)][_0x169035(0x232)]),TSR[_0x169035(0x264)][_0x169035(0x1eb)]=TSR[_0x169035(0x264)][_0x169035(0x2b8)](TSR[_0x169035(0x264)][_0x169035(0x1eb)]),TSR[_0x169035(0x264)][_0x169035(0x1c9)]=_0x1cba18=>{const _0x40dd73=_0x169035;if(_0x1cba18===_0x40dd73(0x211))return 0x1;else return _0x1cba18===_0x40dd73(0x1d2)?0x0:0x2;},TSR[_0x169035(0x264)][_0x169035(0x2b3)]={'name':String(TSR[_0x169035(0x2d8)]['Anim\x201\x20Name']),'block':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2c3)]),'animated':!![],'duration':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2e0)]),'straight':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x1cb)])),'stepUnder':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x2c5)])),'startIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x1ce)]),'endIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x28d)]),'frameRate':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2da)]),'opacity':Number(TSR['Parameters']['Anim\x201\x20Opacity\x20Rate']),'loop':TSR[_0x169035(0x264)][_0x169035(0x1c9)](String(TSR[_0x169035(0x2d8)][_0x169035(0x280)])),'rotate':eval(String(TSR['Parameters'][_0x169035(0x2cd)])),'second':Number(TSR[_0x169035(0x2d8)]['Anim\x201\x20Second\x20Block']),'wet':eval(String(TSR[_0x169035(0x2d8)]['Anim\x201\x20Wet\x20Feet'])),'over':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x2d9)])),'sound':TSR[_0x169035(0x264)][_0x169035(0x2df)]},TSR['footStep'][_0x169035(0x1f6)]={'name':String(TSR[_0x169035(0x2d8)][_0x169035(0x201)]),'block':Number(TSR['Parameters'][_0x169035(0x1f2)]),'animated':!![],'duration':Number(TSR[_0x169035(0x2d8)]['Anim\x202\x20Duration']),'straight':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x233)])),'stepUnder':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x296)])),'startIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x27f)]),'endIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2f2)]),'frameRate':Number(TSR['Parameters'][_0x169035(0x21c)]),'opacity':Number(TSR[_0x169035(0x2d8)][_0x169035(0x275)]),'loop':TSR[_0x169035(0x264)][_0x169035(0x1c9)](String(TSR[_0x169035(0x2d8)]['Anim\x202\x20Loop\x20Type'])),'rotate':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x219)])),'second':Number(TSR['Parameters'][_0x169035(0x1ed)]),'wet':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x2c2)])),'over':eval(String(TSR[_0x169035(0x2d8)]['Anim\x202\x20Over\x20Anim'])),'sound':TSR['footStep'][_0x169035(0x26e)]},TSR['footStep'][_0x169035(0x28e)]={'name':String(TSR[_0x169035(0x2d8)][_0x169035(0x253)]),'block':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2ce)]),'animated':!![],'duration':Number(TSR[_0x169035(0x2d8)][_0x169035(0x215)]),'straight':eval(String(TSR['Parameters'][_0x169035(0x25e)])),'stepUnder':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x28c)])),'startIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x258)]),'endIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x23a)]),'frameRate':Number(TSR[_0x169035(0x2d8)][_0x169035(0x1f0)]),'opacity':Number(TSR[_0x169035(0x2d8)][_0x169035(0x22d)]),'loop':TSR[_0x169035(0x264)]['getCombo'](String(TSR['Parameters']['Anim\x203\x20Loop\x20Type'])),'rotate':eval(String(TSR[_0x169035(0x2d8)]['Anim\x203\x20Rotate'])),'second':Number(TSR[_0x169035(0x2d8)][_0x169035(0x25b)]),'wet':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x2ca)])),'over':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x1da)])),'sound':TSR[_0x169035(0x264)][_0x169035(0x1ca)]},TSR[_0x169035(0x264)]['_anim4']={'name':String(TSR[_0x169035(0x2d8)][_0x169035(0x2d3)]),'block':Number(TSR[_0x169035(0x2d8)]['Anim\x204\x20Block']),'animated':!![],'duration':Number(TSR['Parameters'][_0x169035(0x1fe)]),'straight':eval(String(TSR['Parameters']['Anim\x204\x20Straight\x20Steps'])),'stepUnder':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x2d2)])),'startIndex':Number(TSR[_0x169035(0x2d8)]['Anim\x204\x20Start\x20Index']),'endIndex':Number(TSR['Parameters'][_0x169035(0x279)]),'frameRate':Number(TSR[_0x169035(0x2d8)][_0x169035(0x231)]),'opacity':Number(TSR[_0x169035(0x2d8)]['Anim\x204\x20Opacity\x20Rate']),'loop':TSR[_0x169035(0x264)][_0x169035(0x1c9)](String(TSR[_0x169035(0x2d8)][_0x169035(0x239)])),'rotate':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x1c7)])),'second':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2d6)]),'wet':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x24d)])),'over':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x22c)])),'sound':TSR[_0x169035(0x264)][_0x169035(0x238)]},TSR[_0x169035(0x264)][_0x169035(0x2a5)]={'name':String(TSR[_0x169035(0x2d8)][_0x169035(0x23b)]),'block':Number(TSR[_0x169035(0x2d8)][_0x169035(0x240)]),'animated':!![],'duration':Number(TSR[_0x169035(0x2d8)][_0x169035(0x220)]),'straight':eval(String(TSR['Parameters'][_0x169035(0x269)])),'stepUnder':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x290)])),'startIndex':Number(TSR['Parameters']['Anim\x205\x20Start\x20Index']),'endIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x21a)]),'frameRate':Number(TSR[_0x169035(0x2d8)][_0x169035(0x1e5)]),'opacity':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2a3)]),'loop':TSR['footStep'][_0x169035(0x1c9)](String(TSR[_0x169035(0x2d8)]['Anim\x205\x20Loop\x20Type'])),'rotate':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x2b1)])),'second':Number(TSR['Parameters']['Anim\x205\x20Second\x20Block']),'wet':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x265)])),'over':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x2f3)])),'sound':TSR[_0x169035(0x264)][_0x169035(0x2f6)]},TSR[_0x169035(0x264)][_0x169035(0x1f1)]={'name':String(TSR[_0x169035(0x2d8)][_0x169035(0x262)]),'block':Number(TSR[_0x169035(0x2d8)][_0x169035(0x1f5)]),'animated':!![],'duration':Number(TSR['Parameters'][_0x169035(0x29b)]),'straight':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x244)])),'stepUnder':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x1ec)])),'startIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2c9)]),'endIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x246)]),'frameRate':Number(TSR[_0x169035(0x2d8)][_0x169035(0x292)]),'opacity':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2fa)]),'loop':TSR['footStep']['getCombo'](String(TSR['Parameters']['Anim\x206\x20Loop\x20Type'])),'rotate':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x2c1)])),'second':Number(TSR['Parameters']['Anim\x206\x20Second\x20Block']),'wet':eval(String(TSR[_0x169035(0x2d8)]['Anim\x206\x20Wet\x20Feet'])),'over':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x23f)])),'sound':TSR[_0x169035(0x264)][_0x169035(0x2a2)]},TSR[_0x169035(0x264)][_0x169035(0x272)]={'name':String(TSR[_0x169035(0x2d8)][_0x169035(0x1d9)]),'block':Number(TSR[_0x169035(0x2d8)]['Anim\x207\x20Block']),'animated':!![],'duration':Number(TSR['Parameters'][_0x169035(0x2b6)]),'straight':eval(String(TSR['Parameters'][_0x169035(0x276)])),'stepUnder':eval(String(TSR['Parameters']['Anim\x207\x20Step\x20Under'])),'startIndex':Number(TSR[_0x169035(0x2d8)]['Anim\x207\x20Start\x20Index']),'endIndex':Number(TSR['Parameters']['Anim\x207\x20End\x20Index']),'frameRate':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2ed)]),'opacity':Number(TSR['Parameters']['Anim\x207\x20Opacity\x20Rate']),'loop':TSR['footStep'][_0x169035(0x1c9)](String(TSR[_0x169035(0x2d8)][_0x169035(0x2f7)])),'rotate':eval(String(TSR['Parameters'][_0x169035(0x2a4)])),'second':Number(TSR[_0x169035(0x2d8)]['Anim\x207\x20Second\x20Block']),'wet':eval(String(TSR['Parameters'][_0x169035(0x2e9)])),'over':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x242)])),'sound':TSR[_0x169035(0x264)][_0x169035(0x232)]},TSR['footStep'][_0x169035(0x202)]={'name':String(TSR['Parameters'][_0x169035(0x2bd)]),'block':Number(TSR[_0x169035(0x2d8)][_0x169035(0x22b)]),'animated':!![],'duration':Number(TSR[_0x169035(0x2d8)][_0x169035(0x263)]),'straight':eval(String(TSR[_0x169035(0x2d8)][_0x169035(0x2be)])),'stepUnder':eval(String(TSR['Parameters'][_0x169035(0x27d)])),'startIndex':Number(TSR[_0x169035(0x2d8)][_0x169035(0x261)]),'endIndex':Number(TSR[_0x169035(0x2d8)]['Anim\x208\x20End\x20Index']),'frameRate':Number(TSR['Parameters'][_0x169035(0x1e3)]),'opacity':Number(TSR[_0x169035(0x2d8)][_0x169035(0x285)]),'loop':TSR[_0x169035(0x264)][_0x169035(0x1c9)](String(TSR[_0x169035(0x2d8)][_0x169035(0x28f)])),'rotate':eval(String(TSR['Parameters'][_0x169035(0x26f)])),'second':Number(TSR[_0x169035(0x2d8)][_0x169035(0x2d7)]),'wet':eval(String(TSR['Parameters'][_0x169035(0x2cf)])),'over':eval(String(TSR[_0x169035(0x2d8)]['Anim\x208\x20Over\x20Anim'])),'sound':TSR['footStep'][_0x169035(0x1eb)]},TSR[_0x169035(0x264)][_0x169035(0x27e)]={},TSR['footStep'][_0x169035(0x27e)][TSR[_0x169035(0x264)][_0x169035(0x2b3)][_0x169035(0x24b)]]=TSR[_0x169035(0x264)][_0x169035(0x2b3)],TSR[_0x169035(0x264)][_0x169035(0x27e)][TSR[_0x169035(0x264)]['_anim2'][_0x169035(0x24b)]]=TSR[_0x169035(0x264)][_0x169035(0x1f6)],TSR[_0x169035(0x264)]['_animList'][TSR[_0x169035(0x264)][_0x169035(0x28e)]['block']]=TSR['footStep']['_anim3'],TSR['footStep']['_animList'][TSR[_0x169035(0x264)][_0x169035(0x28a)][_0x169035(0x24b)]]=TSR[_0x169035(0x264)][_0x169035(0x28a)],TSR[_0x169035(0x264)][_0x169035(0x27e)][TSR[_0x169035(0x264)]['_anim5'][_0x169035(0x24b)]]=TSR[_0x169035(0x264)][_0x169035(0x2a5)],TSR[_0x169035(0x264)][_0x169035(0x27e)][TSR[_0x169035(0x264)]['_anim6']['block']]=TSR[_0x169035(0x264)]['_anim6'],TSR['footStep'][_0x169035(0x27e)][TSR[_0x169035(0x264)]['_anim7'][_0x169035(0x24b)]]=TSR[_0x169035(0x264)][_0x169035(0x272)],TSR[_0x169035(0x264)][_0x169035(0x27e)][TSR[_0x169035(0x264)][_0x169035(0x202)][_0x169035(0x24b)]]=TSR[_0x169035(0x264)][_0x169035(0x202)],TSR[_0x169035(0x264)][_0x169035(0x20a)]=DataManager[_0x169035(0x273)],DataManager[_0x169035(0x273)]=function(){const _0x1e098c=_0x169035;if(!TSR[_0x1e098c(0x264)][_0x1e098c(0x20a)]['call'](this))return![];return!TSR[_0x1e098c(0x264)]['_loaded']&&(this[_0x1e098c(0x291)]($dataActors),TSR['footStep'][_0x1e098c(0x207)]=!![]),!![];},DataManager[_0x169035(0x291)]=function(_0x46a71b){const _0x469253=_0x169035;for(let _0x321e9e=0x1;_0x321e9e<_0x46a71b[_0x469253(0x2ab)];_0x321e9e++){let _0x541bc9=/<(?:FOOT STEP|FOOT STEPS):[ ](\d+)>/i,_0xded441=/<(.*)(?:STEP|STEPS):[ ](\d+)>/i,_0x17b9f4=/<(?:NO STEP|NO STEPS)>/i,_0x1b9291=/<(?:BIG STEP|BIG STEPS)>/i,_0x2dfae7=/<(?:SMALL STEP|SMALL STEPS)>/i,_0x227a55=/<(?:STEP SOUND|STEPS SOUND)[ ](\d+):[ ]*(.*(?:\s*,\s*\d+)*)>/i,_0x444ad2=/<(?:4 LEGS STEP|4 LEGS STEPS)>/i,_0x5762d8=/<(?:STEP DURATION|STEPS DURATION):[ ](\d+)>/i,_0x32df98=_0x46a71b[_0x321e9e],_0x53366e=_0x32df98['note'][_0x469253(0x227)](/[\r\n]+/);_0x32df98[_0x469253(0x24f)]=null;for(let _0x3f38dc=0x0;_0x3f38dc<_0x53366e[_0x469253(0x2ab)];_0x3f38dc++){let _0x48e495=_0x53366e[_0x3f38dc];if(_0x48e495[_0x469253(0x297)](_0x541bc9)){let _0x3507b3=parseInt(RegExp['$1']);_0x32df98[_0x469253(0x24f)]=_0x3507b3;}else{if(_0x48e495[_0x469253(0x297)](_0xded441)){let _0x3a0201=_0x53366e[_0x3f38dc]['toLowerCase'](),_0x876abe=_0x3a0201[_0x469253(0x1f8)](_0x3a0201[_0x469253(0x21e)]('<')+0x1,_0x3a0201[_0x469253(0x21e)](_0x469253(0x27b)))[_0x469253(0x2e5)]();for(let _0x43a24c in TSR[_0x469253(0x264)]['_animList']){if(_0x876abe===TSR[_0x469253(0x264)]['_animList'][_0x43a24c][_0x469253(0x21d)][_0x469253(0x206)]()){let _0x218624=parseInt(RegExp['$2']),_0x4d00e4='_'+TSR['footStep'][_0x469253(0x27e)][_0x43a24c][_0x469253(0x21d)][_0x469253(0x206)]()+_0x469253(0x235);_0x32df98[_0x4d00e4]=_0x218624;}}}else{if(_0x48e495[_0x469253(0x297)](_0x17b9f4))_0x32df98[_0x469253(0x2e6)]=!![];else{if(_0x48e495['match'](_0x1b9291))_0x32df98['_scaleStep']=1.5;else{if(_0x48e495[_0x469253(0x297)](_0x2dfae7))_0x32df98[_0x469253(0x287)]=0.5;else{if(_0x48e495[_0x469253(0x297)](_0x227a55)){let _0x49ffe4=parseInt(RegExp['$1']),_0x19cb35=_0x48e495[_0x469253(0x206)](),_0x583d3b=_0x19cb35[_0x469253(0x1f8)](_0x19cb35[_0x469253(0x21e)](':')+0x1);_0x583d3b=TSR[_0x469253(0x264)][_0x469253(0x2b8)](_0x583d3b[_0x469253(0x227)](',')),SoundManager[_0x469253(0x22e)](_0x583d3b),_0x32df98[_0x469253(0x20b)]=_0x32df98['_sound']||{},_0x32df98['_sound'][_0x49ffe4]=_0x583d3b;}else{if(_0x48e495[_0x469253(0x297)](_0x444ad2))_0x32df98[_0x469253(0x282)]=!![];else _0x48e495[_0x469253(0x297)](_0x5762d8)&&(_0x32df98[_0x469253(0x23d)]=parseInt(RegExp['$1']));}}}}}}}}},DataManager['isFootPrintRegionId']=function(_0x4f5d2d){const _0x452faf=_0x169035;if(!$dataMap)return 0x0;let _0x368304=/<(?:FOOT STEP REGION|FOOT STEP REGIONS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i,_0x1b5211=/<(?:WET STEP REGION|WET STEP REGIONS):[ ]*(\d+(?:\s*,\s*\d+)*)>/i,_0x1ef5d0=/<(.*)(?:REGION|REGIONS):[ ]*(\d+\s*\(*\d*\)*(?:\s*,\s*\d+\s*\(*\d*\)*)*)>/i,_0x108419=$dataMap[_0x452faf(0x25c)][_0x452faf(0x227)](/[\r\n]+/);for(let _0x589fc9=0x0;_0x589fc9<_0x108419[_0x452faf(0x2ab)];_0x589fc9++){let _0x394c5e=_0x108419[_0x589fc9];if(_0x394c5e[_0x452faf(0x297)](_0x368304)||_0x394c5e[_0x452faf(0x297)](_0x1b5211)){let _0x538558=_0x108419[_0x589fc9][_0x452faf(0x206)](),_0x5d82ea=_0x538558[_0x452faf(0x1f8)](_0x538558[_0x452faf(0x21e)]('<')+0x1,_0x538558[_0x452faf(0x21e)](_0x452faf(0x2bc)))[_0x452faf(0x2e5)](),_0x2e77bd=_0x108419[_0x589fc9]['slice'](_0x108419[_0x589fc9][_0x452faf(0x21e)](':')+0x1)[_0x452faf(0x227)](',');for(let _0x36076d in _0x2e77bd){if(parseInt(_0x2e77bd[_0x36076d])===_0x4f5d2d)return[_0x5d82ea['toLowerCase'](),0x0];}}else{if(_0x394c5e['match'](_0x1ef5d0)){let _0x379c66=_0x108419[_0x589fc9][_0x452faf(0x206)](),_0x588ed4=_0x379c66[_0x452faf(0x1f8)](_0x379c66[_0x452faf(0x21e)]('<')+0x1,_0x379c66[_0x452faf(0x21e)](_0x452faf(0x2bc)))['trim'](),_0x1cb802=_0x379c66['slice'](_0x379c66[_0x452faf(0x21e)](':')+0x1)['split'](',');for(let _0x3281ab in TSR[_0x452faf(0x264)][_0x452faf(0x27e)]){if(_0x588ed4===TSR[_0x452faf(0x264)][_0x452faf(0x27e)][_0x3281ab]['name'][_0x452faf(0x206)]())for(let _0xb0b829 in _0x1cb802){if(/\(+\d+\)+/['test'](_0x1cb802[_0xb0b829])){let _0x43b456=parseInt(_0x1cb802[_0xb0b829][_0x452faf(0x1f8)](0x0,_0x1cb802[_0xb0b829][_0x452faf(0x21e)]('('))),_0x28c16e=parseInt(_0x1cb802[_0xb0b829][_0x452faf(0x1f8)](_0x1cb802[_0xb0b829][_0x452faf(0x21e)]('(')+0x1));if(_0x43b456===_0x4f5d2d)return[_0x588ed4[_0x452faf(0x206)](),_0x28c16e];}else{if(parseInt(_0x1cb802[_0xb0b829])===_0x4f5d2d)return[_0x588ed4[_0x452faf(0x206)](),0x0];}}}}}}return 0x0;},Game_Event[_0x169035(0x221)][_0x169035(0x248)]=function(){const _0x2e912c=_0x169035;if(!this[_0x2e912c(0x2f1)]())return;let _0x150676=/<(?:FOOT STEP|FOOT STEPS):[ ](\d+)>/i,_0x4263bc=/<(.*)(?:STEP|STEPS):[ ](\d+)>/i,_0x13cfc7=/<(?:NO STEP|NO STEPS)>/i,_0x1009e8=/<(?:BIG STEP|BIG STEPS)>/i,_0x457624=/<(?:SMALL STEP|SMALL STEPS)>/i,_0x56e4fd=/<(?:STEP SOUND|STEPS SOUND)[ ](\d+):[ ]*(.*(?:\s*,\s*\d+)*)>/i,_0x19f988=/<(?:4 LEGS STEP|4 LEGS STEPS)>/i,_0x97e12f=/<(?:STEP SET|STEPS SET):[ ]*(\d+(?:\s*,\s*\d+)*)>/i,_0x2a7590=this['list'](),_0x1ec624=_0x2a7590['length'];for(let _0x410725=0x0;_0x410725<_0x1ec624;++_0x410725){let _0x157933=_0x2a7590[_0x410725];if([0x6c,0x198][_0x2e912c(0x27c)](_0x157933['code'])){if(_0x157933[_0x2e912c(0x20d)][0x0]['match'](_0x150676)){let _0x158a2b=parseInt(RegExp['$1']);this['_baseBlock']=_0x158a2b;}else{if(_0x157933[_0x2e912c(0x20d)][0x0]['match'](_0x4263bc)){let _0x1e7467=_0x157933['parameters'][0x0]['toLowerCase'](),_0x4a7f65=_0x1e7467[_0x2e912c(0x1f8)](_0x1e7467[_0x2e912c(0x21e)]('<')+0x1,_0x1e7467['indexOf']('step'))[_0x2e912c(0x2e5)]();for(let _0x2a3704 in TSR[_0x2e912c(0x264)][_0x2e912c(0x27e)]){if(_0x4a7f65===TSR['footStep']['_animList'][_0x2a3704]['name'][_0x2e912c(0x206)]()){let _0x4363c3=parseInt(RegExp['$2']),_0x11f37a='_'+TSR[_0x2e912c(0x264)][_0x2e912c(0x27e)][_0x2a3704]['name'][_0x2e912c(0x206)]()+_0x2e912c(0x235);this[_0x11f37a]=_0x4363c3;}}}else{if(_0x157933[_0x2e912c(0x20d)][0x0][_0x2e912c(0x297)](_0x13cfc7))this[_0x2e912c(0x2e6)]=!![];else{if(_0x157933[_0x2e912c(0x20d)][0x0][_0x2e912c(0x297)](_0x1009e8))this[_0x2e912c(0x287)]=1.5;else{if(_0x157933[_0x2e912c(0x20d)][0x0]['match'](_0x457624))this[_0x2e912c(0x287)]=0.5;else{if(_0x157933[_0x2e912c(0x20d)][0x0][_0x2e912c(0x297)](_0x56e4fd)){let _0x4695f0=parseInt(RegExp['$1']),_0x432c0e=_0x157933[_0x2e912c(0x20d)][0x0],_0x347e09=_0x432c0e[_0x2e912c(0x1f8)](_0x432c0e['indexOf'](':')+0x1);_0x347e09=TSR[_0x2e912c(0x264)][_0x2e912c(0x2b8)](_0x347e09[_0x2e912c(0x227)](',')),SoundManager[_0x2e912c(0x22e)](_0x347e09),this[_0x2e912c(0x20b)]=this[_0x2e912c(0x20b)]||{},this[_0x2e912c(0x20b)][_0x4695f0]=_0x347e09;}else{if(_0x157933[_0x2e912c(0x20d)][0x0]['match'](_0x19f988))this['_4legs']=!![];else{if(_0x157933['parameters'][0x0][_0x2e912c(0x297)](_0x97e12f)){let _0x135d71=_0x157933[_0x2e912c(0x20d)][0x0],_0x502c2f=_0x135d71[_0x2e912c(0x1f8)](_0x135d71[_0x2e912c(0x21e)](':')+0x1)['split'](',');if(_0x502c2f[0x0])this['_duration']=parseInt(_0x502c2f[0x0]);if(_0x502c2f[0x1])this[_0x2e912c(0x1fd)]=parseInt(_0x502c2f[0x1]);if(_0x502c2f[0x2])this['_Orate']=parseInt(_0x502c2f[0x2]);}}}}}}}}}}},SoundManager[_0x169035(0x22e)]=function(_0x5c3f22){const _0xbda4e5=_0x169035;if(!_0x5c3f22){let _0x4823a8=[];if(TSR[_0xbda4e5(0x264)][_0xbda4e5(0x2a7)])_0x4823a8[_0xbda4e5(0x271)](TSR[_0xbda4e5(0x264)][_0xbda4e5(0x2a7)]);for(let _0x13e9be in TSR['footStep'][_0xbda4e5(0x27e)]){let _0x335d36=TSR[_0xbda4e5(0x264)][_0xbda4e5(0x27e)][_0x13e9be];if(_0x335d36['sound'])_0x4823a8['push'](_0x335d36[_0xbda4e5(0x25d)]);}for(let _0x444ac7 in _0x4823a8){this[_0xbda4e5(0x251)](_0x4823a8[_0x444ac7]);}}else this[_0xbda4e5(0x251)](_0x5c3f22);},SoundManager[_0x169035(0x251)]=function(_0x2fdbde){const _0x4de870=_0x169035;if(!_0x2fdbde)return;AudioManager[_0x4de870(0x2a6)](_0x2fdbde);},TSR[_0x169035(0x264)]['_Scene_Boot_loadSystemImages']=Scene_Boot['loadSystemImages'],Scene_Boot[_0x169035(0x29f)]=function(){const _0x45a60c=_0x169035;ImageManager['reserveSystem']('FootSteps'),SoundManager[_0x45a60c(0x22e)](),TSR['footStep']['_Scene_Boot_loadSystemImages'][_0x45a60c(0x2b0)](this);},Game_Map[_0x169035(0x221)][_0x169035(0x22f)]=function(_0x216dcf,_0xb7de50,_0x34c3f1,_0x2a81d3,_0x240fe1){const _0x14ee8c=_0x169035;let _0x3241bc=$gamePlayer['x'],_0x5ce7a4=$gamePlayer['y'],_0x557b22=$gameMap[_0x14ee8c(0x23e)](_0xb7de50,_0x34c3f1,_0x3241bc,_0x5ce7a4),_0x157105=_0x216dcf-_0x557b22*(_0x216dcf/0x19),_0xb113e1=_0x240fe1?_0x2a81d3*Math[_0x14ee8c(0x1e2)](0x2-_0x240fe1):_0x2a81d3;return[_0x157105>0x0?_0x157105:0x0,_0xb113e1];},TSR[_0x169035(0x264)][_0x169035(0x208)]=Game_Event[_0x169035(0x221)][_0x169035(0x21b)],Game_Event[_0x169035(0x221)][_0x169035(0x21b)]=function(){const _0x2600e4=_0x169035;TSR['footStep'][_0x2600e4(0x208)]['call'](this),this[_0x2600e4(0x248)]();},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x1db)]=function(){return this['_noBlock']||![];},Game_Player[_0x169035(0x221)][_0x169035(0x1db)]=function(){const _0x37b5cb=_0x169035;let _0x3b8c35=$gameParty[_0x37b5cb(0x1d0)]()[_0x37b5cb(0x210)];return $dataActors[_0x3b8c35]['_noBlock']||![];},Game_Follower['prototype'][_0x169035(0x1db)]=function(){const _0x21d36b=_0x169035;let _0x51e55d;if(this[_0x21d36b(0x222)]<=$gameParty[_0x21d36b(0x2af)]()-0x1){let _0x41112f=$gameParty[_0x21d36b(0x26d)]()[this[_0x21d36b(0x222)]]['_actorId'];_0x51e55d=$dataActors[_0x41112f][_0x21d36b(0x2e6)];}return _0x51e55d||![];},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x2d4)]=function(){const _0xd8396e=_0x169035;let _0x37d715=this['makeBlock'](0x0);return _0x37d715[_0xd8396e(0x24b)]=this['_baseBlock']||TSR[_0xd8396e(0x264)][_0xd8396e(0x1e6)],_0x37d715;},Game_Player[_0x169035(0x221)][_0x169035(0x2d4)]=function(){const _0x32ccd6=_0x169035;let _0x5caec6=$gameParty[_0x32ccd6(0x1d0)]()['_actorId'],_0x3f5508=this[_0x32ccd6(0x1df)](0x0);return _0x3f5508['block']=$dataActors[_0x5caec6][_0x32ccd6(0x24f)]||TSR[_0x32ccd6(0x264)][_0x32ccd6(0x1e6)],_0x3f5508;},Game_Follower[_0x169035(0x221)]['baseBlock']=function(){const _0x36b302=_0x169035;let _0x51657a;if(this[_0x36b302(0x222)]<=$gameParty['size']()-0x1){let _0x231797=$gameParty[_0x36b302(0x26d)]()[this[_0x36b302(0x222)]]['_actorId'];_0x51657a=$dataActors[_0x231797][_0x36b302(0x24f)];}let _0x48747e=this[_0x36b302(0x1df)](0x0);return _0x48747e[_0x36b302(0x24b)]=_0x51657a||TSR[_0x36b302(0x264)]['_defaultBlock'],_0x48747e;},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x1cc)]=function(_0x4b1333){const _0x1a1e27=_0x169035;let _0x305c6c=this[_0x1a1e27(0x1df)](_0x4b1333)||{},_0x5e3a2f='_'+_0x4b1333+_0x1a1e27(0x235),_0x42c1a0=this[_0x5e3a2f];return _0x42c1a0?TSR['footStep']['_animList'][_0x42c1a0]||this[_0x1a1e27(0x1df)](0x0,_0x42c1a0):_0x305c6c;},Game_Player[_0x169035(0x221)][_0x169035(0x1cc)]=function(_0x3c3502){const _0x24a04a=_0x169035;let _0x4efd3e=$gameParty['leader']()[_0x24a04a(0x210)],_0x5cfda5=this[_0x24a04a(0x1df)](_0x3c3502)||{},_0x15e44b='_'+_0x3c3502+_0x24a04a(0x235),_0x540da4=$dataActors[_0x4efd3e][_0x15e44b];return _0x540da4?TSR[_0x24a04a(0x264)][_0x24a04a(0x27e)][_0x540da4]||this[_0x24a04a(0x1df)](0x0,_0x540da4):_0x5cfda5;},Game_Follower[_0x169035(0x221)][_0x169035(0x1cc)]=function(_0x452e53){const _0x505a76=_0x169035;let _0x59542e;if(this['_memberIndex']<=$gameParty[_0x505a76(0x2af)]()-0x1){let _0x58fd3b=$gameParty[_0x505a76(0x26d)]()[this[_0x505a76(0x222)]][_0x505a76(0x210)],_0xfa2601='_'+_0x452e53+_0x505a76(0x235);_0x59542e=$dataActors[_0x58fd3b][_0xfa2601];}let _0x50359c=this[_0x505a76(0x1df)](_0x452e53)||{};return _0x59542e?TSR[_0x505a76(0x264)]['_animList'][_0x59542e]||this[_0x505a76(0x1df)](0x0,_0x59542e):_0x50359c;},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x1df)]=function(_0x55ac25,_0x303239){const _0x446a0f=_0x169035;if(!_0x55ac25)return{'block':_0x303239||TSR[_0x446a0f(0x264)]['_defaultBlock'],'animated':0x0,'duration':TSR[_0x446a0f(0x264)][_0x446a0f(0x28b)],'straight':0x0,'stepUnder':0x0,'startIndex':0x0,'endIndex':0x0,'frameRate':0x0,'opacity':TSR[_0x446a0f(0x264)][_0x446a0f(0x274)],'loop':0x0,'rotate':0x0,'second':0x0,'wet':0x0,'over':0x0,'sound':TSR[_0x446a0f(0x264)]['_baseSound']};else for(let _0x13c95f in TSR[_0x446a0f(0x264)][_0x446a0f(0x27e)]){const _0x239ccb=TSR['footStep'][_0x446a0f(0x27e)][_0x13c95f];if(_0x239ccb[_0x446a0f(0x21d)][_0x446a0f(0x206)]()===_0x55ac25)return!_0x239ccb['frameRate']&&(_0x239ccb[_0x446a0f(0x249)]=0x0),_0x239ccb;}},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x25d)]=function(){return this['_sound']||![];},Game_Player[_0x169035(0x221)][_0x169035(0x25d)]=function(){const _0x5f2ead=_0x169035;let _0x310f53=$gameParty[_0x5f2ead(0x1d0)]()[_0x5f2ead(0x210)];return $dataActors[_0x310f53]['_sound']||![];},Game_Follower[_0x169035(0x221)][_0x169035(0x25d)]=function(){const _0x32ddb4=_0x169035;let _0x553607;if(this[_0x32ddb4(0x222)]<=$gameParty[_0x32ddb4(0x2af)]()-0x1){let _0x129093=$gameParty[_0x32ddb4(0x26d)]()[this[_0x32ddb4(0x222)]]['_actorId'];_0x553607=$dataActors[_0x129093]['_sound'];}return _0x553607||![];},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x2db)]=function(_0x9a0b8a){const _0x172fb2=_0x169035;this[_0x172fb2(0x27a)]=_0x9a0b8a;},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x284)]=function(){return this['_footStepsId'];},Game_CharacterBase[_0x169035(0x221)]['stepBlock']=function(_0x5e368a){const _0x1ad6e0=_0x169035;let _0x366842=_0x5e368a===_0x1ad6e0(0x2bb);return this['isLeavingAnim']()&&_0x366842?this[_0x1ad6e0(0x2d4)]():this[_0x1ad6e0(0x2c8)];},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x23c)]=function(_0x2ada00,_0x5c7625){const _0x46abf6=_0x169035,_0x4a0e7c=TSR[_0x46abf6(0x264)][_0x46abf6(0x2b4)]===_0x46abf6(0x24e)?'terrainTag':'regionId';let _0x1d5957=DataManager[_0x46abf6(0x225)]($gameMap[_0x4a0e7c](_0x2ada00,_0x5c7625));this['_stepHue']=_0x1d5957[0x1];if(_0x1d5957[0x0]==='foot\x20step')return this[_0x46abf6(0x217)]=![],this['_anim']=![],this[_0x46abf6(0x2d4)]();else{if(_0x1d5957[0x0]===_0x46abf6(0x2c6))return this[_0x46abf6(0x217)]=!![],this['_anim']=![],this['baseBlock']();else{if(_0x1d5957[0x0]){let _0x4307a3=this[_0x46abf6(0x1cc)](_0x1d5957[0x0]);return this['_wetRegion']=_0x4307a3[_0x46abf6(0x26c)],this['_anim']=_0x4307a3[_0x46abf6(0x249)],_0x4307a3;}}}return 0x0;},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x224)]=function(){const _0x5c49ff=_0x169035;return this[_0x5c49ff(0x1d1)];},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x2b2)]=function(){const _0x15bf7d=_0x169035,_0x296323=TSR[_0x15bf7d(0x264)][_0x15bf7d(0x2b4)]===_0x15bf7d(0x1f7)?_0x15bf7d(0x2dc):_0x15bf7d(0x2e8);let _0x14d322=DataManager[_0x15bf7d(0x225)]($gameMap[_0x296323](this['_x'],this['_y'])),_0x172fb5=this[_0x15bf7d(0x1cc)](_0x14d322[0x0]);return _0x172fb5['animated'];},Game_CharacterBase['prototype'][_0x169035(0x22a)]=function(){const _0x48c443=_0x169035;return this[_0x48c443(0x224)]()&&!this[_0x48c443(0x2b2)]();},Game_CharacterBase[_0x169035(0x221)]['isLeavingUnwetAnim']=function(){const _0x3a9de3=_0x169035;return this[_0x3a9de3(0x224)]()&&!this[_0x3a9de3(0x2b2)]()&&!this['_wetRegion'];},Game_CharacterBase[_0x169035(0x221)][_0x169035(0x288)]=function(){const _0x4c9e65=_0x169035;this[_0x4c9e65(0x27a)]=0x0,this[_0x4c9e65(0x29d)]=0x0;},Game_Character['prototype']['moveStraight']=function(_0x13ec11){const _0x46ff6b=_0x169035;Game_CharacterBase[_0x46ff6b(0x221)][_0x46ff6b(0x2a9)][_0x46ff6b(0x2b0)](this,_0x13ec11);let _0x55b9f3=this[_0x46ff6b(0x23c)](this['_x'],this['_y']),_0x30b77d=this['_x']!==this[_0x46ff6b(0x283)],_0x2f3769=this['_y']!==this['_realY'],_0x292c1f=_0x30b77d||_0x2f3769,_0x138941=TSR[_0x46ff6b(0x264)]['_onlyLastFollower']?this[_0x46ff6b(0x222)]===$gameParty[_0x46ff6b(0x2af)]()-0x1:this[_0x46ff6b(0x222)]<=$gameParty[_0x46ff6b(0x2af)]()-0x1;this['_stepBlock']=this['setStepBlock'](this[_0x46ff6b(0x283)],this[_0x46ff6b(0x2e2)]),this[_0x46ff6b(0x1c6)]=this[_0x46ff6b(0x2c8)][_0x46ff6b(0x249)];this[_0x46ff6b(0x2c8)]&&!_0x55b9f3&&this[_0x46ff6b(0x217)]&&(this['_wetFeet']=!![],this[_0x46ff6b(0x1fc)]=0x0);if(this[_0x46ff6b(0x2ea)]&&this[_0x46ff6b(0x1fc)]<0x4){if(_0x292c1f)this[_0x46ff6b(0x1fc)]++;}else this[_0x46ff6b(0x1fc)]=0x0,this[_0x46ff6b(0x2ea)]=0x0;if(this[_0x46ff6b(0x2ea)]&&this['_wetFeetCount']>0x1&&!this['_animatedStep'])this[_0x46ff6b(0x2c8)]=this[_0x46ff6b(0x2d4)]();if(this[_0x46ff6b(0x2c8)]&&_0x292c1f&&!this['noBlock']()){if(!this[_0x46ff6b(0x222)])this[_0x46ff6b(0x2db)](_0x13ec11);else _0x138941&&$gamePlayer[_0x46ff6b(0x1e0)][_0x46ff6b(0x1e8)]&&this[_0x46ff6b(0x2db)](_0x13ec11);}},TSR['footStep'][_0x169035(0x2ae)]=Sprite_Character[_0x169035(0x221)][_0x169035(0x299)],Sprite_Character[_0x169035(0x221)][_0x169035(0x299)]=function(){const _0x539438=_0x169035;TSR['footStep']['_Sprite_Character_initMembers'][_0x539438(0x2b0)](this),this[_0x539438(0x2ef)]=[],this['_stepOverAnim']=[],this[_0x539438(0x281)]=[],this['_stepFrameIndex']=0x0;},TSR['footStep'][_0x169035(0x2cc)]=Sprite_Character[_0x169035(0x221)][_0x169035(0x20c)],Sprite_Character[_0x169035(0x221)][_0x169035(0x20c)]=function(){const _0x4c19a7=_0x169035;TSR['footStep'][_0x4c19a7(0x2cc)]['call'](this),this[_0x4c19a7(0x2b5)]();},Sprite_Character['prototype'][_0x169035(0x20e)]=function(){const _0x3212ac=_0x169035,_0x5f2c4e=this[_0x3212ac(0x2b9)]['footStepsId']();_0x5f2c4e>0x0&&(this['startFootSteps'](_0x5f2c4e),Imported[_0x3212ac(0x2c4)]&&(this[_0x3212ac(0x2b9)][_0x3212ac(0x26b)]()&&this['startFootSteps'](_0x5f2c4e,!![])),this['_character'][_0x3212ac(0x288)]());},Sprite_Character['prototype']['startFootSteps']=function(_0x26fc21,_0x5d4ae2){const _0x1cc3b5=_0x169035;this[_0x1cc3b5(0x247)]=!this[_0x1cc3b5(0x2b9)][_0x1cc3b5(0x22a)]()?this[_0x1cc3b5(0x2b9)][_0x1cc3b5(0x2c8)][_0x1cc3b5(0x2bb)]:![];this['_character'][_0x1cc3b5(0x2c8)]['second']&&(this['_overAnim']=TSR[_0x1cc3b5(0x264)][_0x1cc3b5(0x27e)][this[_0x1cc3b5(0x2b9)][_0x1cc3b5(0x2c8)][_0x1cc3b5(0x2bb)]][_0x1cc3b5(0x252)]);let _0x465377=this[_0x1cc3b5(0x241)]('first',_0x26fc21,![],_0x5d4ae2);_0x5d4ae2?this[_0x1cc3b5(0x281)][_0x1cc3b5(0x271)](_0x465377):this[_0x1cc3b5(0x2ef)][_0x1cc3b5(0x271)](_0x465377);if(this[_0x1cc3b5(0x247)]){if(this[_0x1cc3b5(0x256)]){let _0x8e55c8=this['createStepOverAnim']('first',_0x26fc21,this[_0x1cc3b5(0x247)],_0x5d4ae2);_0x5d4ae2?this[_0x1cc3b5(0x281)][_0x1cc3b5(0x271)](_0x8e55c8):this[_0x1cc3b5(0x2e4)][_0x1cc3b5(0x271)](_0x8e55c8);}else{let _0x44cfb2=this['createStepSprite']('first',_0x26fc21,this[_0x1cc3b5(0x247)],_0x5d4ae2);_0x5d4ae2?this[_0x1cc3b5(0x281)][_0x1cc3b5(0x271)](_0x44cfb2):this[_0x1cc3b5(0x2ef)][_0x1cc3b5(0x271)](_0x44cfb2);}}if(!this[_0x1cc3b5(0x2b9)][_0x1cc3b5(0x2ec)]){let _0xc72157=this[_0x1cc3b5(0x241)](_0x1cc3b5(0x2bb),_0x26fc21,![],_0x5d4ae2);_0x5d4ae2?this[_0x1cc3b5(0x281)]['push'](_0xc72157):this[_0x1cc3b5(0x2ef)][_0x1cc3b5(0x271)](_0xc72157);if(this[_0x1cc3b5(0x247)]){if(this[_0x1cc3b5(0x256)]){let _0x1a8b1a=this[_0x1cc3b5(0x230)](_0x1cc3b5(0x2bb),_0x26fc21,this[_0x1cc3b5(0x247)],_0x5d4ae2);_0x5d4ae2?this[_0x1cc3b5(0x281)][_0x1cc3b5(0x271)](_0x1a8b1a):this[_0x1cc3b5(0x2e4)][_0x1cc3b5(0x271)](_0x1a8b1a);}else{let _0x83a60c=this[_0x1cc3b5(0x241)](_0x1cc3b5(0x2bb),_0x26fc21,this[_0x1cc3b5(0x247)],_0x5d4ae2);_0x5d4ae2?this[_0x1cc3b5(0x281)]['push'](_0x83a60c):this['_footStepsSprite'][_0x1cc3b5(0x271)](_0x83a60c);}}}},Sprite_Character[_0x169035(0x221)][_0x169035(0x241)]=function(_0x43c31b,_0x396e54,_0x289fbf,_0x981457){const _0x21d519=_0x169035;let _0x287433=new Sprite_FootSteps(this[_0x21d519(0x2b9)][_0x21d519(0x1ee)]);_0x43c31b===_0x21d519(0x266)?(_0x287433['x']=this['x'],_0x287433['y']=this['y']):(_0x287433['x']=this['x']+this[_0x21d519(0x2de)](_0x396e54),_0x287433['y']=this['y']+this[_0x21d519(0x29c)](_0x396e54));let _0x41065a=this[_0x21d519(0x2a8)](this[_0x21d519(0x2b9)]['moveSpeed']()),_0x1b47f4=TSR[_0x21d519(0x264)][_0x21d519(0x27e)][_0x289fbf],_0x566f3c=this[_0x21d519(0x2b9)]['stepBlock'](_0x43c31b),_0x56d0ba=_0x289fbf?_0x1b47f4:_0x566f3c;_0x56d0ba[_0x21d519(0x2e3)]&&(_0x287433[_0x21d519(0x1d5)]=this[_0x21d519(0x286)](_0x396e54)*0x5a*Math['PI']/0xb4);this[_0x21d519(0x2b9)]['scaleStep']&&_0x56d0ba[_0x21d519(0x249)]&&(_0x287433[_0x21d519(0x234)]['x']=this['_character'][_0x21d519(0x287)],_0x287433[_0x21d519(0x234)]['y']=this[_0x21d519(0x2b9)]['_scaleStep']);!this['_character'][_0x21d519(0x282)]&&!_0x56d0ba[_0x21d519(0x212)]&&this['setSpritePos'](_0x287433,_0x396e54,_0x43c31b,_0x289fbf,_0x981457);if(this['_character']['isLeavingUnwetAnim']())_0x287433[_0x21d519(0x2dd)]=![];return _0x287433[_0x21d519(0x1ef)](_0x56d0ba,_0x396e54,this['stepFrameIndex'](),_0x56d0ba[_0x21d519(0x249)],_0x43c31b,_0x41065a,this[_0x21d519(0x2b9)],_0x981457),_0x981457?SceneManager[_0x21d519(0x2d0)][_0x21d519(0x1ea)][_0x21d519(0x281)][_0x21d519(0x250)](_0x287433):SceneManager[_0x21d519(0x2d0)][_0x21d519(0x1ea)]['_footStepSprite'][_0x21d519(0x250)](_0x287433),_0x287433;},Sprite_Character[_0x169035(0x221)][_0x169035(0x230)]=function(_0x3027db,_0x4ea702,_0x2296dd,_0x3bd73d){const _0x1ecf96=_0x169035;let _0x41157d=new Sprite_FootSteps(this[_0x1ecf96(0x2b9)]['_stepHue']);_0x3027db===_0x1ecf96(0x266)?(_0x41157d['x']=this['x'],_0x41157d['y']=this['y']):(_0x41157d['x']=this['x']+this[_0x1ecf96(0x2de)](_0x4ea702),_0x41157d['y']=this['y']+this[_0x1ecf96(0x29c)](_0x4ea702));let _0x517a13=this[_0x1ecf96(0x2a8)](this['_character'][_0x1ecf96(0x1ff)]()),_0x55f916=TSR[_0x1ecf96(0x264)][_0x1ecf96(0x27e)][_0x2296dd],_0x290ec2=this[_0x1ecf96(0x2b9)][_0x1ecf96(0x29a)](_0x3027db),_0x5ee38d=_0x2296dd?_0x55f916:_0x290ec2;_0x5ee38d[_0x1ecf96(0x2e3)]&&(_0x41157d['rotation']=this[_0x1ecf96(0x286)](_0x4ea702)*0x5a*Math['PI']/0xb4);this[_0x1ecf96(0x2b9)][_0x1ecf96(0x287)]&&_0x5ee38d[_0x1ecf96(0x249)]&&(_0x41157d[_0x1ecf96(0x234)]['x']=this[_0x1ecf96(0x2b9)][_0x1ecf96(0x287)],_0x41157d[_0x1ecf96(0x234)]['y']=this['_character'][_0x1ecf96(0x287)]);!this[_0x1ecf96(0x2b9)][_0x1ecf96(0x282)]&&!_0x5ee38d[_0x1ecf96(0x212)]&&this[_0x1ecf96(0x2bf)](_0x41157d,_0x4ea702,_0x3027db,_0x2296dd,_0x3bd73d);if(this[_0x1ecf96(0x2b9)][_0x1ecf96(0x1e7)]())_0x41157d[_0x1ecf96(0x2dd)]=![];return _0x41157d[_0x1ecf96(0x1ef)](_0x5ee38d,_0x4ea702,this[_0x1ecf96(0x216)](),_0x5ee38d['animated'],_0x3027db,_0x517a13,this[_0x1ecf96(0x2b9)],_0x3bd73d),_0x3bd73d?SceneManager[_0x1ecf96(0x2d0)][_0x1ecf96(0x1ea)][_0x1ecf96(0x281)][_0x1ecf96(0x250)](_0x41157d):SceneManager[_0x1ecf96(0x2d0)]['_spriteset'][_0x1ecf96(0x228)][_0x1ecf96(0x250)](_0x41157d),_0x41157d;},Sprite_Character[_0x169035(0x221)][_0x169035(0x2bf)]=function(_0x14ec78,_0x4dda9d,_0x58953d,_0x4637e8,_0x388881){const _0x161ca1=_0x169035;let _0x252235=0x0,_0x207eee=_0x388881?_0x161ca1(0x1d7):'_firstDash',_0x26f36e=_0x388881?'_reflectAnimDash':_0x161ca1(0x259);_0x58953d===_0x161ca1(0x266)?!_0x4637e8?this[_0x161ca1(0x2b9)][_0x161ca1(0x2ec)]&&!this[_0x207eee]?(_0x252235=!![],this[_0x207eee]=!![]):(_0x252235=![],this[_0x207eee]=![]):(this[_0x26f36e]=this[_0x207eee]?0x0:0x1,this[_0x161ca1(0x2b9)][_0x161ca1(0x2ec)]&&!this[_0x26f36e]?(_0x252235=!![],this[_0x26f36e]=!![]):(_0x252235=![],this[_0x26f36e]=![])):_0x252235=!![],_0x252235?_0x4dda9d===0x2||_0x4dda9d===0x8?_0x14ec78['x']+=0x4:_0x14ec78['y']+=0x4:_0x4dda9d===0x2||_0x4dda9d===0x8?_0x14ec78['x']-=0x4:_0x14ec78['y']-=0x4;},Sprite_Character[_0x169035(0x221)][_0x169035(0x216)]=function(){const _0x773fb7=_0x169035;let _0x350a0e=this[_0x773fb7(0x2aa)];if(!this['_goLeft']&&this['_stepFrameIndex']<0x2){this[_0x773fb7(0x2aa)]++;if(this[_0x773fb7(0x2aa)]===0x2)this[_0x773fb7(0x1d4)]=!![];}else{if(this[_0x773fb7(0x1d4)]&&this[_0x773fb7(0x2aa)]>0x0){this['_stepFrameIndex']--;if(this[_0x773fb7(0x2aa)]===0x0)this[_0x773fb7(0x1d4)]=![];}}return _0x350a0e;},Sprite_Character['prototype'][_0x169035(0x2de)]=function(_0xf8959){if(_0xf8959===0x2||_0xf8959===0x8)return 0x0;return _0xf8959===0x4?-0x18:0x18;},Sprite_Character[_0x169035(0x221)][_0x169035(0x29c)]=function(_0x232f79){if(_0x232f79===0x4||_0x232f79===0x6)return 0x0;return _0x232f79===0x8?-0x18:0x18;},Sprite_Character[_0x169035(0x221)]['getSpeedFactor']=function(_0x6ddb76){switch(_0x6ddb76){case 0x1:return 0x3c;case 0x2:return 0x2c;case 0x3:return 0x1b;case 0x4:return 0xa;case 0x5:return 0x8;case 0x6:return 0x6;default:return 0xa;}},Sprite_Character[_0x169035(0x221)]['getAngle']=function(_0x4e1db9){if(_0x4e1db9===0x2)return 0x2;else{if(_0x4e1db9===0x4)return 0x3;else return _0x4e1db9===0x6?0x1:0x0;}},Sprite_Character[_0x169035(0x221)][_0x169035(0x2b5)]=function(){const _0x2a580c=_0x169035;this[_0x2a580c(0x20e)](),this[_0x2a580c(0x2ef)][_0x2a580c(0x2ab)]>0x0&&(!this[_0x2a580c(0x2ef)][0x0][_0x2a580c(0x1f4)]()&&(SceneManager[_0x2a580c(0x2d0)][_0x2a580c(0x1ea)][_0x2a580c(0x2c0)][_0x2a580c(0x1dc)](this[_0x2a580c(0x2ef)][0x0]),this[_0x2a580c(0x2ef)][_0x2a580c(0x209)]())),this[_0x2a580c(0x2e4)][_0x2a580c(0x2ab)]>0x0&&(!this[_0x2a580c(0x2e4)][0x0][_0x2a580c(0x1f4)]()&&(SceneManager['_scene'][_0x2a580c(0x1ea)][_0x2a580c(0x228)][_0x2a580c(0x1dc)](this[_0x2a580c(0x2e4)][0x0]),this[_0x2a580c(0x2e4)][_0x2a580c(0x209)]())),this[_0x2a580c(0x281)][_0x2a580c(0x2ab)]>0x0&&(!this['_reflectionSteps'][0x0][_0x2a580c(0x1f4)]()&&(SceneManager['_scene'][_0x2a580c(0x1ea)]['_reflectionSteps'][_0x2a580c(0x1dc)](this['_reflectionSteps'][0x0]),this[_0x2a580c(0x281)]['shift']()));},TSR[_0x169035(0x264)][_0x169035(0x2f8)]=Spriteset_Map[_0x169035(0x221)][_0x169035(0x1e4)],Spriteset_Map[_0x169035(0x221)][_0x169035(0x1e4)]=function(){const _0x5a482c=_0x169035;TSR[_0x5a482c(0x264)]['_Spriteset_Map_createLowerLayer']['call'](this),this['createFootStepSprite']();},Spriteset_Map[_0x169035(0x221)][_0x169035(0x2ee)]=function(){const _0x5406bb=_0x169035;this[_0x5406bb(0x2c0)]=new Sprite(),this[_0x5406bb(0x2c0)]['setFrame'](0x0,0x0,this[_0x5406bb(0x25f)],this[_0x5406bb(0x25a)]),this[_0x5406bb(0x2c0)]['z']=0x2,this[_0x5406bb(0x1cd)][_0x5406bb(0x250)](this['_footStepSprite']),this[_0x5406bb(0x228)]=new Sprite(),this[_0x5406bb(0x228)][_0x5406bb(0x1e1)](0x0,0x0,this[_0x5406bb(0x25f)],this[_0x5406bb(0x25a)]),this['_spriteOverAnim']['z']=0x7,this[_0x5406bb(0x1cd)][_0x5406bb(0x250)](this[_0x5406bb(0x228)]),this[_0x5406bb(0x281)]=new Sprite(),this[_0x5406bb(0x281)]['setFrame'](0x0,0x0,this[_0x5406bb(0x25f)],this[_0x5406bb(0x25a)]),this[_0x5406bb(0x281)]['z']=-0.5,this['_tilemap'][_0x5406bb(0x250)](this[_0x5406bb(0x281)]);});function Sprite_FootSteps(){const _0x4daa86=_0x169035;this[_0x4daa86(0x294)][_0x4daa86(0x223)](this,arguments);}Sprite_FootSteps[_0x169035(0x221)]=Object['create'](Sprite[_0x169035(0x221)]),Sprite_FootSteps['prototype'][_0x169035(0x237)]=Sprite_FootSteps,Sprite_FootSteps[_0x169035(0x221)][_0x169035(0x294)]=function(_0x2b27c1){const _0x38bd76=_0x169035;Sprite[_0x38bd76(0x221)]['initialize'][_0x38bd76(0x2b0)](this),this[_0x38bd76(0x299)](),this[_0x38bd76(0x1fa)](_0x2b27c1);},Sprite_FootSteps['prototype'][_0x169035(0x299)]=function(){const _0x1211b6=_0x169035;this[_0x1211b6(0x27a)]=0x0,this[_0x1211b6(0x23d)]=0x0,this[_0x1211b6(0x205)]=0x0,this[_0x1211b6(0x1d6)]['x']=0.5,this['anchor']['y']=0.5,this[_0x1211b6(0x289)]=0x0,this[_0x1211b6(0x203)]=0x0;},Sprite_FootSteps['prototype'][_0x169035(0x1fa)]=function(_0x179248){const _0x2312a0=_0x169035;this[_0x2312a0(0x2e1)]=ImageManager[_0x2312a0(0x1f9)]('FootSteps',_0x179248),this[_0x2312a0(0x1e1)](0x0,0x0,0x0,0x0);},Sprite_FootSteps[_0x169035(0x221)][_0x169035(0x1ef)]=function(_0x3595aa,_0x3f252e,_0x4a57c9,_0x45e87d,_0x2a90d6,_0x1c9182,_0xb8837d,_0x58c31e){const _0x34e2b1=_0x169035,_0x46b525=new Sprite(),_0x39fee6=_0xb8837d[_0x34e2b1(0x2ea)],_0x21e226=_0xb8837d[_0x34e2b1(0x283)],_0x2be0da=_0xb8837d[_0x34e2b1(0x2e2)],_0x2263b1=_0xb8837d[_0x34e2b1(0x287)];if(_0x3595aa[_0x34e2b1(0x25d)]||_0xb8837d['sound']()){const _0x11614d=_0xb8837d[_0x34e2b1(0x25d)]()?_0xb8837d[_0x34e2b1(0x25d)]()[_0x3595aa[_0x34e2b1(0x24b)]]||_0x3595aa[_0x34e2b1(0x25d)]:_0x3595aa[_0x34e2b1(0x25d)],_0x28c0ec=_0x11614d['maxVol'],_0x144d72=_0x11614d[_0x34e2b1(0x20f)],_0x342083=$gameMap[_0x34e2b1(0x22f)](_0x28c0ec,_0x21e226,_0x2be0da,_0x144d72,_0x2263b1);_0x11614d[_0x34e2b1(0x270)]=_0x342083[0x0],_0x11614d[_0x34e2b1(0x243)]=_0x342083[0x1];if(!_0x39fee6)AudioManager[_0x34e2b1(0x204)](_0x11614d);}_0x46b525[_0x34e2b1(0x2e1)]=this['bitmap'],this[_0x34e2b1(0x2b9)]=_0xb8837d,this[_0x34e2b1(0x298)]=_0x2a90d6,this[_0x34e2b1(0x1dd)]=_0x1c9182,this[_0x34e2b1(0x23d)]=_0xb8837d[_0x34e2b1(0x23d)]||_0x3595aa['duration'],this['_duration']+=_0x2a90d6==='first'?_0x1c9182:_0x1c9182*0x2,this[_0x34e2b1(0x2c8)]=_0x3595aa[_0x34e2b1(0x24b)],this[_0x34e2b1(0x1cf)]=_0x3595aa[_0x34e2b1(0x2e7)],this[_0x34e2b1(0x277)]=_0x3f252e,this[_0x34e2b1(0x2f5)]=_0x45e87d?_0x3595aa['startIndex']:_0x4a57c9,this[_0x34e2b1(0x2ad)]=_0xb8837d['_Orate']||_0x3595aa[_0x34e2b1(0x289)],this[_0x34e2b1(0x205)]=_0x45e87d,this['_animRate']=_0xb8837d[_0x34e2b1(0x1fd)]||_0x3595aa[_0x34e2b1(0x278)],this[_0x34e2b1(0x2b7)]=_0x3595aa[_0x34e2b1(0x2f4)],this['_animLoop']=_0x3595aa[_0x34e2b1(0x211)],this[_0x34e2b1(0x268)]=0x0,this[_0x34e2b1(0x2ac)]=_0x58c31e,this[_0x34e2b1(0x254)]=$gameMap[_0x34e2b1(0x213)]();const _0x24fb62=_0x45e87d?Math[_0x34e2b1(0x2d1)](this['_stepFrame']/0x3):(_0x3f252e-0x2)/0x2,_0x5aa1fa=this[_0x34e2b1(0x254)],_0x297ac8=this[_0x34e2b1(0x254)],_0x4ae67f=(this[_0x34e2b1(0x1f3)](this['_stepBlock'])+_0x4a57c9)*_0x5aa1fa,_0x3009b6=(this[_0x34e2b1(0x257)](this[_0x34e2b1(0x2c8)])+_0x24fb62)*_0x297ac8;this['setFrame'](_0x4ae67f,_0x3009b6,_0x5aa1fa,_0x297ac8),this[_0x34e2b1(0x1fb)]=$gameMap[_0x34e2b1(0x2ba)],this[_0x34e2b1(0x295)]=$gameMap[_0x34e2b1(0x2eb)],_0x58c31e&&(this['y']-=0x2*(this['_character'][_0x34e2b1(0x26a)]()*this[_0x34e2b1(0x254)])-this[_0x34e2b1(0x254)]);},Sprite_FootSteps['prototype'][_0x169035(0x1f3)]=function(_0x3a9f5c){return _0x3a9f5c%0x4*0x3;},Sprite_FootSteps[_0x169035(0x221)][_0x169035(0x257)]=function(_0x276804){const _0x210600=_0x169035;return Math[_0x210600(0x2d1)](_0x276804/0x4)*0x4;},Sprite_FootSteps[_0x169035(0x221)][_0x169035(0x20c)]=function(){const _0x116763=_0x169035;Sprite['prototype'][_0x116763(0x20c)][_0x116763(0x2b0)](this),this['updateStepScroll'](),this['_duration']>0x0&&(this[_0x116763(0x1cf)]&&(this[_0x116763(0x289)]=0xff,this['_hasFadeIn']=!![],this[_0x116763(0x203)]=this[_0x116763(0x1dd)],this[_0x116763(0x1cf)]=![]),this[_0x116763(0x298)]==='second'&&this[_0x116763(0x203)]<this[_0x116763(0x1dd)]?this['_stepWait']++:this[_0x116763(0x289)]<0xff&&!this['_hasFadeIn']?(this[_0x116763(0x23d)]--,this[_0x116763(0x289)]+=Math[_0x116763(0x2d1)](0xff/this[_0x116763(0x1dd)])):(this[_0x116763(0x2a0)]=!![],this['_animStep']&&this[_0x116763(0x268)]%this[_0x116763(0x1e9)]===0x0&&this[_0x116763(0x214)](),this[_0x116763(0x268)]++,this['_duration']--,this['opacity']-=this[_0x116763(0x2ad)]));},Sprite_FootSteps[_0x169035(0x221)]['updateStepScroll']=function(){const _0x25fc48=_0x169035;let _0x6e2471=0x0,_0x3fba6d=0x0;$gameMap[_0x25fc48(0x2ba)]!==this[_0x25fc48(0x1fb)]&&(_0x6e2471=$gameMap[_0x25fc48(0x2ba)]-this['_lastDisplayX']),$gameMap[_0x25fc48(0x2eb)]!==this['_lastDisplayY']&&(_0x3fba6d=$gameMap['_displayY']-this[_0x25fc48(0x295)]),this['x']=this['x']-_0x6e2471*$gameMap[_0x25fc48(0x213)](),this['y']=this['y']-_0x3fba6d*$gameMap['tileHeight'](),this[_0x25fc48(0x1fb)]=$gameMap[_0x25fc48(0x2ba)],this['_lastDisplayY']=$gameMap[_0x25fc48(0x2eb)];},Sprite_FootSteps[_0x169035(0x221)]['updateFootStepAnim']=function(){const _0x330a67=_0x169035,_0x28873c=this['_tileWidth'],_0x3f00eb=this[_0x330a67(0x2f5)],_0x3b2316=Math[_0x330a67(0x2d1)](_0x3f00eb/0x3),_0xe41e4=_0x28873c,_0x206f98=_0x28873c,_0x2cc3ce=(this[_0x330a67(0x1f3)](this[_0x330a67(0x2c8)])+_0x3f00eb%0x3)*_0xe41e4,_0x14c871=(this[_0x330a67(0x257)](this['_stepBlock'])+_0x3b2316)*_0x206f98;this['setFrame'](_0x2cc3ce,_0x14c871,_0xe41e4,_0x206f98),this['_stepFrame']=this['setStepAnimFrame'](_0x3f00eb);},Sprite_FootSteps['prototype'][_0x169035(0x2c7)]=function(_0x26d08a){const _0x5c4c1c=_0x169035;if(_0x26d08a<this[_0x5c4c1c(0x2b7)])_0x26d08a++;else{if(this['_animLoop']===0x1)_0x26d08a=0x0;else this[_0x5c4c1c(0x1d8)]===0x2?_0x26d08a=this[_0x5c4c1c(0x2b7)]:this[_0x5c4c1c(0x23d)]=0x0;}return _0x26d08a;},Sprite_FootSteps[_0x169035(0x221)][_0x169035(0x1f4)]=function(){const _0x54ac08=_0x169035;return this[_0x54ac08(0x23d)]>0x0;};
})();

//== END =================================================================================
//========================================================================================